/*
 * Decompiled with CFR 0.152.
 */
package tools3d;

import java.util.logging.Logger;
import tools3d.Geometry;
import tools3d.GeometryTools;
import tools3d.SimpleShape3D;
import tools3d.Vector3D;
import tools3d.Vector3DTools;

public class Sphere
extends SimpleShape3D {
    private static Logger log = Logger.getLogger("NanoTiler_debug");

    public Sphere(Vector3D position, double radius) {
        this.setPosition(position);
        this.setBoundingRadius(radius);
        this.setDimensions(new Vector3D(radius, radius, radius));
    }

    @Override
    public Geometry createGeometry(double angleDelta) {
        if (!this.isGeometryUpToDate()) {
            this.updateGeometry(angleDelta);
        }
        return this.geometry;
    }

    @Override
    public String getShapeName() {
        return "Sphere";
    }

    protected void updateGeometry(double angleDelta) {
        Vector3D pos = this.getPosition();
        int nPoints = (int)(Math.PI * 2 / angleDelta);
        double radius = this.getBoundingRadius();
        log.fine("Generating sphere with " + nPoints + " points!");
        Vector3D[] sphereVectors = Vector3DTools.generateSpherePoints(nPoints, radius, pos);
        double perArrea = Math.PI * 4 * radius * radius / (double)nPoints;
        double lengthTarget = Math.sqrt(perArrea / Math.PI);
        double lengthMin = 0.5 * lengthTarget;
        double lengthMax = 2.5 * lengthTarget;
        double angleTarget = 1.0471975511965976;
        double angleMin = 0.9 * angleTarget;
        double angleMax = 1.1 * angleTarget;
        this.geometry = GeometryTools.triangularize(sphereVectors, angleMin, angleMax, lengthMin, lengthMax);
        log.fine("triang. result: " + this.geometry.size());
        this.geometry.setProperties(this.getProperties());
        this.geometry.setSelected(this.isSelected());
        this.setGeometryUpToDate(true);
    }
}

