/*
 * Decompiled with CFR 0.152.
 */
package tools3d;

import java.io.Serializable;
import java.util.logging.Logger;
import numerictools.DoubleTools;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import tools3d.Matrix3DTools;
import tools3d.Vector4D;

public class Vector3D
implements Serializable {
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    public static final double SIMILAR_CUTOFF = 1.0E-5;
    public static final Vector3D ZVEC = new Vector3D(0.0, 0.0, 0.0);
    public static final Vector3D EX = new Vector3D(1.0, 0.0, 0.0);
    public static final Vector3D EY = new Vector3D(0.0, 1.0, 0.0);
    public static final Vector3D EZ = new Vector3D(0.0, 0.0, 1.0);
    double x;
    double y;
    double z;
    int index;

    public Vector3D() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
    }

    public Vector3D(Vector3D other) {
        this.copy(other);
    }

    public Vector3D(double _x, double _y, double _z) {
        this.x = _x;
        this.y = _y;
        this.z = _z;
    }

    public Vector3D(Vector4D v) {
        this.x = v.getX();
        this.y = v.getY();
        this.z = v.getZ();
    }

    public Vector3D(double x, double y, double z, int index) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.index = index;
    }

    public boolean isOrigin() {
        return this.getX() == 0.0 && this.getY() == 0.0 && this.getZ() == 0.0;
    }

    public boolean isReasonable() {
        return DoubleTools.isReasonable(this.x) && DoubleTools.isReasonable(this.y) && DoubleTools.isReasonable(this.z);
    }

    public boolean isValid() {
        return !Double.isNaN(this.x) && !Double.isNaN(this.y) && !Double.isNaN(this.z);
    }

    public boolean equals(Vector3D v) {
        return this.getX() == v.getX() && this.getY() == v.getY() && this.getZ() == v.getZ();
    }

    public void add(Vector3D a) {
        this.x += a.x;
        this.y += a.y;
        this.z += a.z;
    }

    public static Vector3D average(Vector3D v1, Vector3D v2) {
        return v1.plus(v2).mul(0.5);
    }

    public Object clone() {
        return new Vector3D(this.x, this.y, this.z);
    }

    public static boolean similar(double a, double b) {
        return Math.abs(a - b) < 1.0E-5;
    }

    public boolean similar(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Vector3D)) {
            return false;
        }
        Vector3D v = (Vector3D)other;
        return Vector3D.similar(this.x, v.x) && Vector3D.similar(this.y, v.y) && Vector3D.similar(this.z, v.z);
    }

    public double[] getArrayCopy() {
        double[] ary = new double[]{this.x, this.y, this.z};
        return ary;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double angle(Vector3D other) {
        double len = this.length();
        double len2 = other.length();
        if (len <= 0.0 || len2 <= 0.0) {
            return 0.0;
        }
        double cosa = this.dot(other) / (len * len2);
        if (cosa > 1.0) {
            cosa = 1.0;
        } else if (cosa < -1.0) {
            cosa = -1.0;
        }
        return Math.acos(cosa);
    }

    public static double torsionAngle(Vector3D v1, Vector3D v2, Vector3D v3, Vector3D v4) {
        Vector3D va = v1.minus(v2);
        Vector3D vb = v4.minus(v3);
        return va.angle(vb);
    }

    private static Vector3D genAngleVec(double angle, double r) {
        double x = r * Math.cos(angle);
        double y = r * Math.sin(angle);
        double z = 0.0;
        return new Vector3D(x, y, z);
    }

    public static double angleDiff(double angle1, double angle2) {
        double r = 1.0;
        Vector3D v1 = Vector3D.genAngleVec(angle1, r);
        Vector3D v2 = Vector3D.genAngleVec(angle2, r);
        return v1.angle(v2);
    }

    public static double angleNorm(double angle) {
        double r = 1.0;
        Vector3D v1 = Vector3D.genAngleVec(angle, r);
        Vector3D v0 = Vector3D.genAngleVec(0.0, r);
        double result = v1.angle(v0);
        if (v1.getY() < 0.0) {
            result = -result;
        }
        return result;
    }

    public static void testAngleDiff() {
        double tol = 0.001;
        assert (Vector3D.angleDiff(0.0, Math.PI * 2) < tol);
        assert (Math.abs(Vector3D.angleDiff(0.0, Math.PI) - Math.PI) < tol);
    }

    public double angle(Vector3D other1, Vector3D other2) {
        Vector3D dv1 = other1.minus(this);
        Vector3D dv2 = other2.minus(this);
        return dv1.angle(dv2);
    }

    public double distance(Vector3D other) {
        assert (this.isValid() && other.isValid());
        return this.minus(other).length();
    }

    public double distanceSquare(Vector3D other) {
        assert (this.isValid());
        assert (other.isValid());
        return this.minus(other).lengthSquare();
    }

    public Vector3D plus(Vector3D a) {
        return new Vector3D(this.x + a.x, this.y + a.y, this.z + a.z);
    }

    public void sub(Vector3D a) {
        this.x -= a.x;
        this.y -= a.y;
        this.z -= a.z;
    }

    public void swap(Vector3D a) {
        double h = this.x;
        this.x = a.x;
        a.x = h;
        h = this.y;
        this.y = a.y;
        a.y = h;
        h = this.z;
        this.z = a.z;
        a.z = h;
    }

    public Vector3D minus(Vector3D a) {
        return new Vector3D(this.x - a.x, this.y - a.y, this.z - a.z);
    }

    public Vector3D mul(double a) {
        return new Vector3D(this.x * a, this.y * a, this.z * a);
    }

    public void scale(double a) {
        this.x *= a;
        this.y *= a;
        this.z *= a;
    }

    public void scale(Vector3D v) {
        this.x *= v.getX();
        this.y *= v.getY();
        this.z *= v.getZ();
    }

    public double max() {
        double result = Math.abs(this.x);
        if (Math.abs(this.y) > result) {
            result = Math.abs(this.y);
        }
        if (Math.abs(this.z) > result) {
            result = Math.abs(this.z);
        }
        return result;
    }

    public static Vector3D mean(Vector3D a, Vector3D b) {
        Vector3D result = a.plus(b);
        result.scale(0.5);
        return result;
    }

    public void normalize() {
        double len = this.length();
        if (len > 0.0) {
            this.scale(1.0 / len);
        }
    }

    public void rotate(Vector3D center, Vector3D axis, double angle) {
        if (angle == 0.0) {
            return;
        }
        double distOrig = this.distance(center);
        Vector3D position = new Vector3D(this.getX(), this.getY(), this.getZ());
        Vector3D shiftedPos = position.minus(center);
        Vector3D rotatedPos = Matrix3DTools.rotate(shiftedPos, axis, angle);
        rotatedPos.add(center);
        this.set(rotatedPos.getX(), rotatedPos.getY(), rotatedPos.getZ());
        double distNew = this.distance(center);
        if (Math.abs(distOrig - distNew) > 0.01) {
            log.warning("Strange rotation: " + position + " " + center + " " + axis + " " + Math.toDegrees(angle) + " : " + rotatedPos + " distances: " + distOrig + " " + distNew);
        }
        assert (Math.abs(distOrig - distNew) < 0.01);
    }

    @Test
    public void testRotate() {
        Vector3D testVector = new Vector3D(1.0, 1.0, 1.0);
        testVector.rotate(new Vector3D(0.0, 0.0, 0.0), new Vector3D(0.0, 1.0, 0.0), Math.PI);
        assert (testVector.similar(new Vector3D(-1.0, 1.0, -1.0)));
    }

    public double dot(Vector3D a) {
        return this.x * a.x + this.y * a.y + this.z * a.z;
    }

    public Vector3D cross(Vector3D a) {
        return new Vector3D(this.y * a.z - this.z * a.y, this.z * a.x - this.x * a.z, this.x * a.y - this.y * a.x);
    }

    public double length() {
        assert (this.isValid());
        return Math.sqrt(this.dot(this));
    }

    public double lengthSquare() {
        assert (this.isValid());
        double result = this.dot(this);
        assert (!(Double.isNaN(result) || Double.isInfinite(result) || result < 0.0));
        return result;
    }

    public void copy(Vector3D a) {
        this.x = a.x;
        this.y = a.y;
        this.z = a.z;
    }

    public void set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void setArray(double[] v, int start) {
        assert (start + 2 < v.length);
        v[start] = this.getX();
        v[start + 1] = this.getY();
        v[start + 2] = this.getZ();
    }

    public void setX(double _x) {
        this.x = _x;
    }

    public void setY(double _y) {
        this.y = _y;
    }

    public void setZ(double _z) {
        this.z = _z;
    }

    public String toString() {
        return "(v3 " + this.getX() + " " + this.getY() + " " + this.getZ() + " )";
    }

    @BeforeClass
    public void setUp() {
    }

    @Test
    public void testPlus() {
        Vector3D v1 = new Vector3D(1.0, 0.0, 0.0);
        Vector3D v2 = new Vector3D(0.0, 2.0, 0.0);
        Vector3D v3 = v1.plus(v2);
        assert (v3.similar(new Vector3D(1.0, 2.0, 0.0)));
    }
}

