/*
 * Decompiled with CFR 0.152.
 */
package tools3d;

import java.io.Serializable;
import java.util.logging.Logger;
import numerictools.DoubleTools;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import tools3d.Vector3D;

public class Vector4D
implements Serializable {
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    public static final double SIMILAR_CUTOFF = 1.0E-5;
    double x;
    double y;
    double z;
    double w;

    public Vector4D() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
        this.w = 1.0;
    }

    public Vector4D(Vector3D other) {
        this.x = other.getX();
        this.y = other.getY();
        this.z = other.getZ();
        this.w = 1.0;
    }

    public Vector4D(Vector4D other) {
        this.copy(other);
    }

    public Vector4D(double _x, double _y, double _z) {
        this.x = _x;
        this.y = _y;
        this.z = _z;
        this.w = 1.0;
    }

    public Vector4D(double _x, double _y, double _z, double _w) {
        this.x = _x;
        this.y = _y;
        this.z = _z;
        this.w = _w;
    }

    public boolean isReasonable() {
        return DoubleTools.isReasonable(this.x) && DoubleTools.isReasonable(this.y) && DoubleTools.isReasonable(this.z) && DoubleTools.isReasonable(this.w);
    }

    public boolean isValid() {
        return !Double.isNaN(this.x) && !Double.isNaN(this.y) && !Double.isNaN(this.z) && !Double.isNaN(this.w) && !Double.isInfinite(this.x) && !Double.isInfinite(this.y) && !Double.isInfinite(this.z) && !Double.isInfinite(this.w);
    }

    public boolean equals(Vector4D v) {
        return this.getX() == v.getX() && this.getY() == v.getY() && this.getZ() == v.getZ() && this.getW() == v.getW();
    }

    public void add(Vector4D a) {
        this.x += a.x;
        this.y += a.y;
        this.z += a.z;
        this.w += a.w;
    }

    public static Vector4D average(Vector4D v1, Vector4D v2) {
        return v1.plus(v2).mul(0.5);
    }

    public Object clone() {
        return new Vector4D(this.x, this.y, this.z, this.w);
    }

    public static boolean similar(double a, double b) {
        return Math.abs(a - b) < 1.0E-5;
    }

    public boolean similar(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Vector4D)) {
            return false;
        }
        Vector4D v = (Vector4D)other;
        return Vector4D.similar(this.x, v.x) && Vector4D.similar(this.y, v.y) && Vector4D.similar(this.z, v.z) && Vector4D.similar(this.w, v.w);
    }

    public double[] getArrayCopy() {
        double[] ary = new double[]{this.x, this.y, this.z, this.w};
        return ary;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double getW() {
        return this.w;
    }

    public double angle(Vector4D other) {
        double len = this.length();
        double len2 = other.length();
        if (len <= 0.0 || len2 <= 0.0) {
            return 0.0;
        }
        double cosa = this.dot(other) / (len * len2);
        if (cosa > 1.0) {
            cosa = 1.0;
        } else if (cosa < -1.0) {
            cosa = -1.0;
        }
        return Math.acos(cosa);
    }

    public double angle(Vector4D other1, Vector4D other2) {
        Vector4D dv1 = other1.minus(this);
        Vector4D dv2 = other2.minus(this);
        return dv1.angle(dv2);
    }

    public double distance(Vector4D other) {
        return this.minus(other).length();
    }

    public double distanceSquare(Vector4D other) {
        assert (this.isValid());
        assert (other.isValid());
        return this.minus(other).lengthSquare();
    }

    public Vector4D plus(Vector4D a) {
        return new Vector4D(this.x + a.x, this.y + a.y, this.z + a.z, this.w + a.w);
    }

    public void sub(Vector4D a) {
        this.x -= a.x;
        this.y -= a.y;
        this.z -= a.z;
        this.w -= a.w;
    }

    public Vector3D subVector() {
        return new Vector3D(this.x, this.y, this.z);
    }

    public Vector4D minus(Vector4D a) {
        return new Vector4D(this.x - a.x, this.y - a.y, this.z - a.z, this.w - a.w);
    }

    public Vector4D mul(double a) {
        return new Vector4D(this.x * a, this.y * a, this.z * a, this.w * a);
    }

    public void scale(double a) {
        this.x *= a;
        this.y *= a;
        this.z *= a;
        this.w *= a;
    }

    public void scale(Vector4D v) {
        this.x *= v.getX();
        this.y *= v.getY();
        this.z *= v.getZ();
        this.w *= v.getW();
    }

    public static Vector4D mean(Vector4D a, Vector4D b) {
        Vector4D result = a.plus(b);
        result.scale(0.5);
        return result;
    }

    public void normalize() {
        double len = this.length();
        if (len > 0.0) {
            this.scale(1.0 / len);
        }
    }

    public double dot(Vector4D a) {
        return this.x * a.x + this.y * a.y + this.z * a.z + this.w * a.w;
    }

    public double length() {
        assert (this.isValid());
        return Math.sqrt(this.dot(this));
    }

    public double lengthSquare() {
        assert (this.isValid());
        double result = this.dot(this);
        return result;
    }

    public void copy(Vector4D a) {
        this.x = a.x;
        this.y = a.y;
        this.z = a.z;
        this.w = a.w;
    }

    public void copy(Vector3D a) {
        this.x = a.x;
        this.y = a.y;
        this.z = a.z;
        this.w = 1.0;
    }

    public void set(double x, double y, double z, double w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public Vector4D cross(Vector4D v) {
        Vector4D ret = new Vector4D(0.0, 0.0, 0.0, 0.0);
        ret.setX(this.y * v.z - this.z * v.y);
        ret.setY(this.z * v.x - this.x * v.z);
        ret.setZ(this.x * v.y - this.y * v.x);
        return ret;
    }

    public void setX(double _x) {
        this.x = _x;
    }

    public void setY(double _y) {
        this.y = _y;
    }

    public void setZ(double _z) {
        this.z = _z;
    }

    public void setW(double _w) {
        this.w = _w;
    }

    public void swap(Vector4D a) {
        double h = this.x;
        this.x = a.x;
        a.x = h;
        h = this.y;
        this.y = a.y;
        a.y = h;
        h = this.z;
        this.z = a.z;
        a.z = h;
        h = this.w;
        this.w = a.w;
        a.w = h;
    }

    public String toString() {
        return "(v4 " + this.getX() + " " + this.getY() + " " + this.getZ() + " " + this.getW() + " )";
    }

    @BeforeClass
    public void setUp() {
    }

    @Test
    public void testPlus() {
        Vector4D v1 = new Vector4D(1.0, 0.0, 0.0, 1.0);
        Vector4D v2 = new Vector4D(0.0, 2.0, 0.0, 1.0);
        Vector4D v3 = v1.plus(v2);
        assert (v3.similar(new Vector4D(1.0, 2.0, 0.0, 2.0)));
    }
}

