/*
 * Decompiled with CFR 0.152.
 */
package tools3d.objects3d.modeling;

import controltools.ModelChangeEvent;
import generaltools.Randomizer;
import java.util.Random;
import java.util.logging.Logger;
import tools3d.Orientable;
import tools3d.Vector3D;
import tools3d.objects3d.LinkSet;
import tools3d.objects3d.Object3DSet;
import tools3d.objects3d.modeling.AbstractMinimizer;
import tools3d.objects3d.modeling.CoordinateSnapShot;
import tools3d.objects3d.modeling.ForceField;
import tools3d.objects3d.modeling.MinimizationParameters;
import tools3d.objects3d.modeling.Minimizer;
import tools3d.objects3d.modeling.SimpleCoordinateSnapShot;
import tools3d.objects3d.modeling.Trajectory;

public class MonteCarloMinimizer
extends AbstractMinimizer
implements Minimizer {
    Object3DSet objects;
    LinkSet links;
    MinimizationParameters parameters;
    CoordinateSnapShot origSnapShot;
    Trajectory trajectory;
    Random random = Randomizer.getInstance();
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    MonteCarloParameters mcParameters;

    public MonteCarloMinimizer(Object3DSet objects, LinkSet links, MinimizationParameters parameters, MonteCarloParameters mcParameters) {
        this.objects = objects;
        this.links = links;
        this.parameters = parameters;
        this.origSnapShot = this.generateSnapShot();
        this.mcParameters = mcParameters;
    }

    public MonteCarloMinimizer(Object3DSet objects, LinkSet links, MinimizationParameters parameters) {
        this.objects = objects;
        this.links = links;
        this.parameters = parameters;
        this.origSnapShot = this.generateSnapShot();
        log.finest("Snapshot of size " + this.origSnapShot.size() + " generated");
        this.mcParameters = new MonteCarloParameters();
    }

    @Override
    public void run() {
        ForceField ff = this.parameters.getForceField();
        for (int i = 0; i < this.parameters.getTimeStepMax(); ++i) {
            double oldEnergy = ff.energy(this.objects, this.links);
            CoordinateSnapShot oldSnapShot = this.generateSnapShot();
            this.mutate(this.objects);
            double newEnergy = ff.energy(this.objects, this.links);
            log.finest("minimizing step " + (i + 1) + " old " + oldEnergy + " new " + newEnergy);
            if (newEnergy > oldEnergy) {
                this.applySnapShot(oldSnapShot);
                continue;
            }
            if (!(newEnergy < oldEnergy)) continue;
        }
        this.fireModelChanged(new ModelChangeEvent(this));
    }

    public void applySnapShot(CoordinateSnapShot snapShot) {
        snapShot.applySnapShot(this.objects);
    }

    public CoordinateSnapShot generateSnapShot() {
        return new SimpleCoordinateSnapShot(this.objects, this.parameters.getPrototype());
    }

    public void mutate(Object3DSet objects) {
        CoordinateSnapShot snapShot = this.generateSnapShot();
        int nCoord = this.random.nextInt(snapShot.size());
        Orientable orient = snapShot.getCoordinate(nCoord);
        this.mutate(orient);
        this.applySnapShot(snapShot);
    }

    public void mutate(Orientable orient) {
        Vector3D pos = orient.getPosition();
        this.mutate(pos);
    }

    public void mutate(Vector3D pos) {
        pos.setX(pos.getX() + 2.0 * this.mcParameters.randomWidth * (this.random.nextDouble() - 0.5));
        pos.setY(pos.getY() + 2.0 * this.mcParameters.randomWidth * (this.random.nextDouble() - 0.5));
        pos.setZ(pos.getZ() + 2.0 * this.mcParameters.randomWidth * (this.random.nextDouble() - 0.5));
    }

    public class MonteCarloParameters {
        double randomWidth = 1.0;
    }
}

