/*
 * Decompiled with CFR 0.152.
 */
package tools3d.splines;

import no.geosoft.cc.geometry.spline.SplineFactory;
import tools3d.Vector3D;
import tools3d.splines.Spline3DFactory;

public class SimpleSplineFactory
implements Spline3DFactory {
    private double[] translateToArray(Vector3D[] points) {
        double[] result = new double[3 * points.length];
        int pc = 0;
        for (int i = 0; i < points.length; ++i) {
            result[pc++] = points[i].getX();
            result[pc++] = points[i].getY();
            result[pc++] = points[i].getZ();
        }
        return result;
    }

    private Vector3D[] translateToVectors(double[] data) {
        Vector3D[] result = new Vector3D[data.length / 3];
        int pc = 0;
        for (int i = 0; i < result.length; ++i) {
            result[i] = new Vector3D(data[pc++], data[pc++], data[pc++]);
        }
        return result;
    }

    @Override
    public Vector3D[] createBezier(Vector3D[] controlPoints, int nParts) {
        return this.translateToVectors(SplineFactory.createBezier((double[])this.translateToArray(controlPoints), (int)nParts));
    }

    @Override
    public Vector3D[] createCatmullRom(Vector3D[] controlPoints, int nParts) {
        return this.translateToVectors(SplineFactory.createCatmullRom((double[])this.translateToArray(controlPoints), (int)nParts));
    }

    @Override
    public Vector3D[] createCubic(Vector3D[] controlPoints, int nParts) {
        return this.translateToVectors(SplineFactory.createCubic((double[])this.translateToArray(controlPoints), (int)nParts));
    }
}

