/*
 * Decompiled with CFR 0.152.
 */
package viewer.commands;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import rnadesign.rnacontrol.Object3DController;
import tools3d.Vector3D;
import tools3d.objects3d.Object3DSetTools;
import tools3d.objects3d.SimpleObject3DSet;
import viewer.commands.ToggableDisplayCommand;
import viewer.display.Display;
import viewer.view.AimablePerspectiveView;

public class CenterOnMolecularMass
extends ToggableDisplayCommand {
    private Object3DController controller;

    public CenterOnMolecularMass(Object3DController controller) {
        this.controller = controller;
    }

    @Override
    public JComponent component(final Display d) {
        JButton button = new JButton("Center");
        button.setToolTipText("Center");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CenterOnMolecularMass.this.execute(d);
            }
        });
        return button;
    }

    @Override
    public String description() {
        return "Centers view on the center of the loaded object";
    }

    @Override
    public void executeOn(Display d) {
        Vector3D com = Object3DSetTools.centerOfMass(new SimpleObject3DSet(this.controller.getGraph()));
        d.getView().lookAt(com.getX(), com.getY(), com.getZ());
        d.repaint();
    }

    @Override
    public void executeOff(Display d) {
        if (d.getView() instanceof AimablePerspectiveView) {
            ((AimablePerspectiveView)d.getView()).point(null);
        } else {
            this.executeOn(d);
        }
    }

    @Override
    public KeyStroke keyStroke() {
        return KeyStroke.getKeyStroke(67, 2, true);
    }
}

