/*
 * Decompiled with CFR 0.152.
 */
package viewer.commands;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import tools3d.Vector3D;
import tools3d.Vector4D;
import viewer.commands.ToggableDisplayCommand;
import viewer.display.Display;
import viewer.event.DisplayEvent;
import viewer.event.DisplayLayoutListener;
import viewer.event.DisplayViewChangedListener;
import viewer.event.SelectionEvent;
import viewer.event.SelectionListener;
import viewer.graph.Object3DRenderableGraph;
import viewer.graphics.Gizmo;
import viewer.graphics.Material;
import viewer.graphics.ObjectTranslationManipulator;
import viewer.rnadesign.GraphControllerDisplayManager;
import viewer.util.Tools;
import viewer.view.OrthogonalView;
import viewer.view.PerspectiveView;
import viewer.view.XYView;
import viewer.view.XZView;

public class TranslateObjects
extends ToggableDisplayCommand
implements SelectionListener,
DisplayViewChangedListener,
DisplayLayoutListener {
    private GraphControllerDisplayManager manager;
    private Vector4D position;
    private static final Material X_MATERIAL = new Material(Color.green);
    private static final Material Y_MATERIAL = new Material(Color.red);
    private static final Material Z_MATERIAL = new Material(Color.blue);
    private static final Material S_MATERIAL = new Material(Color.yellow);

    public TranslateObjects(GraphControllerDisplayManager manager) {
        this.manager = manager;
    }

    @Override
    public void executeOff(Display d) {
        this.manager.setViewTranslationEnabled(true);
        this.manager.getSelector().setMaxNumberSimultaneousSelections(Integer.MAX_VALUE);
        this.manager.getSelector().removeSelectionListener(this);
        this.manager.removeDisplayLayoutListener(this);
        this.manager.getDisplay().removeDisplayViewChangedListener(this);
        for (Display dd : this.manager.getDisplay().getDisplays()) {
            dd.setGizmo(null);
            dd.setGizmoEnabled(false);
        }
        this.position = null;
        this.manager.repaint();
    }

    @Override
    public void executeOn(Display d) {
        this.manager.setViewTranslationEnabled(false);
        this.manager.getSelector().setMaxNumberSimultaneousSelections(1);
        this.manager.getSelector().addSelectionListener(this);
        this.manager.addDisplayLayoutListener(this);
        this.manager.getDisplay().addDisplayViewChangedListener(this);
        this.manager.getSelector().deselectAll();
        this.manager.repaint();
    }

    @Override
    public void displayLayoutChanged(DisplayEvent e) {
        if (this.position == null) {
            return;
        }
        this.manager.setViewTranslationEnabled(false);
        for (Display dd : this.manager.getDisplay().getDisplays()) {
            this.attachGizmo(dd);
            dd.setGizmoEnabled(true);
        }
    }

    @Override
    public void displayChanged(DisplayEvent e) {
        if (e.getId() == 1) {
            this.attachGizmo(e.getDisplay());
            e.getDisplay().setMouseTranslationEnabled(false);
        }
    }

    private void attachGizmo(Display d) {
        if (this.position == null) {
            return;
        }
        if (d.getView() instanceof PerspectiveView) {
            d.setGizmo(new PerspectiveGizmo(this.position));
        } else {
            d.setGizmo(new OrthogonalGizmo(this.position));
        }
        d.setGizmoEnabled(true);
    }

    @Override
    public void objectSelected(SelectionEvent e) {
        this.position = new Vector4D(e.getSelectedObject().getPosition());
        this.position.setW(1.0);
        for (Display dd : this.manager.getDisplay().getDisplays()) {
            this.attachGizmo(dd);
            dd.setGizmoEnabled(true);
        }
    }

    @Override
    public void objectDeselected(SelectionEvent e) {
        this.position = null;
        for (Display dd : this.manager.getDisplay().getDisplays()) {
            dd.setGizmo(null);
            dd.setGizmoEnabled(false);
            dd.repaint();
        }
    }

    @Override
    public JComponent component(final Display d) {
        JButton button = new JButton("Translate");
        button.setToolTipText("Translate");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TranslateObjects.this.execute(d);
            }
        });
        return button;
    }

    @Override
    public String description() {
        return "Translate Object Mode";
    }

    @Override
    public KeyStroke keyStroke() {
        return KeyStroke.getKeyStroke(84, 2, true);
    }

    private class PerspectiveGizmo
    extends ObjectTranslationManipulator
    implements Gizmo,
    MouseListener,
    MouseMotionListener {
        private Vector4D p;
        private Display d;
        private boolean onAxis;
        private boolean onPlane;
        private Vector4D u;
        private Vector4D v;

        public PerspectiveGizmo(Vector4D position) {
            super(position);
            this.onAxis = false;
            this.onPlane = false;
            this.setXAxisMaterial(X_MATERIAL);
            this.setYAxisMaterial(Y_MATERIAL);
            this.setZAxisMaterial(Z_MATERIAL);
            this.setXyPlaneMaterial(X_MATERIAL);
            this.setXzPlaneMaterial(Z_MATERIAL);
            this.setYzPlaneMaterial(Y_MATERIAL);
        }

        @Override
        public MouseListener getMouseListener() {
            return this;
        }

        @Override
        public MouseMotionListener getMouseMotionListener() {
            return this;
        }

        @Override
        public void setDisplay(Display d) {
            this.d = d;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Vector4D ray = new Vector4D();
            this.p = new Vector4D();
            Tools.screenTo3DSpace(e.getPoint(), this.d, ray, this.p);
            int axisMask = this.getIntersectionAxis(ray, this.p);
            int planeMask = this.getIntersectionPlane(ray, this.p);
            System.out.println("Plane Mask: " + planeMask);
            if (axisMask == 1) {
                this.onAxis = true;
                this.u = Tools.X_AXIS;
            } else if (axisMask == 2) {
                this.onAxis = true;
                this.u = Tools.Y_AXIS;
            } else if (axisMask == 4) {
                this.onAxis = true;
                this.u = Tools.Z_AXIS;
            }
            if (this.onAxis) {
                return;
            }
            if (planeMask == 1) {
                this.onPlane = true;
                this.u = Tools.X_AXIS;
                this.v = Tools.Y_AXIS;
            } else if (planeMask == 2) {
                this.onPlane = true;
                this.u = Tools.X_AXIS;
                this.v = Tools.Z_AXIS;
            } else if (planeMask == 4) {
                this.onPlane = true;
                this.u = Tools.Y_AXIS;
                this.v = Tools.Z_AXIS;
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.p = null;
            this.onPlane = false;
            this.onAxis = false;
            this.v = null;
            this.u = null;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            Vector4D np = new Vector4D();
            Tools.screenTo3DSpace(e.getPoint(), this.d, null, np);
            double x = (np.getX() - this.p.getX()) * 2.0;
            double y = (-np.getY() + this.p.getY()) * 2.0;
            if (this.onAxis) {
                Vector3D translation = new Vector3D(this.u);
                translation = translation.mul(x);
                TranslateObjects.this.manager.getSelector().getSelected()[0].translate(translation);
                Object3DRenderableGraph graph = TranslateObjects.this.manager.getRenderer().getGraph(TranslateObjects.this.manager.getSelector().getSelected()[0]);
                graph.update();
                this.setPosition(this.getPosition().plus(this.u.mul(x)));
            } else if (this.onPlane) {
                Vector4D t = this.u.mul(x).plus(this.v.mul(y));
                Vector3D translation = new Vector3D(t);
                TranslateObjects.this.manager.getSelector().getSelected()[0].translate(translation);
                Object3DRenderableGraph graph = TranslateObjects.this.manager.getRenderer().getGraph(TranslateObjects.this.manager.getSelector().getSelected()[0]);
                graph.update();
                this.setPosition(this.getPosition().plus(t));
            }
            this.p = np;
            TranslateObjects.this.manager.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Vector4D ray = new Vector4D();
            Vector4D origin = new Vector4D();
            Tools.screenTo3DSpace(e.getPoint(), this.d, ray, origin);
            if (!this.getBoundingVolume().intersectRay(ray, origin)) {
                this.setXAxisMaterial(X_MATERIAL);
                this.setYAxisMaterial(Y_MATERIAL);
                this.setZAxisMaterial(Z_MATERIAL);
                this.setXyPlaneMaterial(X_MATERIAL);
                this.setXzPlaneMaterial(Z_MATERIAL);
                this.setYzPlaneMaterial(Y_MATERIAL);
                TranslateObjects.this.manager.repaint();
                return;
            }
            int axisMask = this.getIntersectionAxis(ray, origin);
            int planeMask = this.getIntersectionPlane(ray, origin);
            System.out.println("Axis Mask: " + axisMask);
            System.out.println("Plane Mask: " + planeMask);
            boolean onAxis = false;
            if (axisMask == 1) {
                this.setXAxisMaterial(S_MATERIAL);
                this.setYAxisMaterial(Y_MATERIAL);
                this.setZAxisMaterial(Z_MATERIAL);
                onAxis = true;
            } else if (axisMask == 2) {
                this.setXAxisMaterial(X_MATERIAL);
                this.setYAxisMaterial(S_MATERIAL);
                this.setZAxisMaterial(Z_MATERIAL);
                onAxis = true;
            } else if (axisMask == 4) {
                this.setXAxisMaterial(X_MATERIAL);
                this.setYAxisMaterial(Y_MATERIAL);
                this.setZAxisMaterial(S_MATERIAL);
                onAxis = true;
            } else {
                this.setXAxisMaterial(X_MATERIAL);
                this.setYAxisMaterial(Y_MATERIAL);
                this.setZAxisMaterial(Z_MATERIAL);
            }
            if (onAxis) {
                this.setXyPlaneMaterial(X_MATERIAL);
                this.setXzPlaneMaterial(Z_MATERIAL);
                this.setYzPlaneMaterial(Y_MATERIAL);
                TranslateObjects.this.manager.repaint();
                return;
            }
            if (planeMask == 1) {
                this.setXyPlaneMaterial(S_MATERIAL);
                this.setXzPlaneMaterial(Z_MATERIAL);
                this.setYzPlaneMaterial(Y_MATERIAL);
            } else if (planeMask == 2) {
                this.setXyPlaneMaterial(X_MATERIAL);
                this.setXzPlaneMaterial(S_MATERIAL);
                this.setYzPlaneMaterial(Y_MATERIAL);
            } else if (planeMask == 4) {
                this.setXyPlaneMaterial(X_MATERIAL);
                this.setXzPlaneMaterial(Z_MATERIAL);
                this.setYzPlaneMaterial(S_MATERIAL);
            } else {
                this.setXyPlaneMaterial(X_MATERIAL);
                this.setXzPlaneMaterial(Z_MATERIAL);
                this.setYzPlaneMaterial(Y_MATERIAL);
            }
            TranslateObjects.this.manager.repaint();
        }
    }

    private class OrthogonalGizmo
    extends ObjectTranslationManipulator
    implements Gizmo,
    MouseListener,
    MouseMotionListener {
        private Vector4D p;
        private Vector4D uTranslation;
        private Vector4D vTranslation;
        private boolean intersectsU;
        private boolean intersectsV;
        private int allowedAxisIntersectionMask;
        private int uMask;
        private int vMask;
        private Display d;

        public OrthogonalGizmo(Vector4D position) {
            super(position);
            this.intersectsU = false;
            this.intersectsV = false;
            this.allowedAxisIntersectionMask = 0;
            this.uMask = 0;
            this.vMask = 0;
            this.setXAxisMaterial(X_MATERIAL);
            this.setYAxisMaterial(Y_MATERIAL);
            this.setZAxisMaterial(Z_MATERIAL);
        }

        @Override
        public MouseListener getMouseListener() {
            return this;
        }

        @Override
        public MouseMotionListener getMouseMotionListener() {
            return this;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            Vector4D np = new Vector4D();
            Tools.screenTo3DSpace(e.getPoint(), this.d, null, np);
            Vector4D diff = np.minus(this.p);
            double u = diff.dot(this.uTranslation);
            double v = diff.dot(this.vTranslation);
            Vector3D uT = new Vector3D(this.uTranslation);
            uT = uT.mul(u);
            Vector3D vT = new Vector3D(this.vTranslation);
            vT = vT.mul(v);
            if (this.intersectsU) {
                TranslateObjects.this.manager.getSelector().getSelected()[0].translate(uT);
                this.setPosition(this.getPosition().plus(this.uTranslation.mul(u)));
            } else if (this.intersectsV) {
                TranslateObjects.this.manager.getSelector().getSelected()[0].translate(vT);
                this.setPosition(this.getPosition().plus(this.vTranslation.mul(v)));
            } else {
                TranslateObjects.this.manager.getSelector().getSelected()[0].translate(uT.plus(vT));
                this.setPosition(this.getPosition().plus(this.uTranslation.mul(u)));
                this.setPosition(this.getPosition().plus(this.vTranslation.mul(v)));
            }
            TranslateObjects.this.manager.repaint();
            this.p = np;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Vector4D ray = new Vector4D();
            Vector4D origin = new Vector4D();
            Tools.screenTo3DSpace(e.getPoint(), this.d, ray, origin);
            int mask = this.getIntersectionAxis(ray, origin) & this.allowedAxisIntersectionMask;
            if (mask == 0 || mask == this.allowedAxisIntersectionMask) {
                this.setXAxisMaterial(X_MATERIAL);
                this.setYAxisMaterial(Y_MATERIAL);
                this.setZAxisMaterial(Z_MATERIAL);
                this.d.repaint();
                return;
            }
            if ((mask & 1) == 1) {
                this.setXAxisMaterial(S_MATERIAL);
            } else {
                this.setXAxisMaterial(X_MATERIAL);
            }
            if ((mask & 2) == 2) {
                this.setYAxisMaterial(S_MATERIAL);
            } else {
                this.setYAxisMaterial(Y_MATERIAL);
            }
            if ((mask & 4) == 4) {
                this.setZAxisMaterial(S_MATERIAL);
            } else {
                this.setZAxisMaterial(Z_MATERIAL);
            }
            this.d.repaint();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.p = new Vector4D();
            Vector4D ray = new Vector4D();
            Tools.screenTo3DSpace(e.getPoint(), this.d, ray, this.p);
            int mask = this.getIntersectionAxis(ray, this.p) & this.allowedAxisIntersectionMask;
            if ((mask & this.uMask) == this.uMask) {
                this.intersectsU = true;
            } else if ((mask & this.vMask) == this.vMask) {
                this.intersectsV = true;
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.p = null;
            this.intersectsU = false;
            this.intersectsV = false;
        }

        @Override
        public void setDisplay(Display d) {
            this.d = d;
            OrthogonalView view = d.getView();
            this.setXzPlaneEnabled(false);
            this.setXyPlaneEnabled(false);
            this.setYzPlaneEnabled(false);
            if (view instanceof XYView) {
                this.setZAxisEnabled(false);
                this.uTranslation = new Vector4D(view.getViewDirection().getZ() < 0.0 ? 1.0 : -1.0, 0.0, 0.0, 0.0);
                this.vTranslation = new Vector4D(0.0, view.getViewDirectionNormal().getY(), 0.0);
                this.uMask = 1;
                this.vMask = 2;
            } else if (view instanceof XZView) {
                this.setYAxisEnabled(false);
                this.uTranslation = new Vector4D(view.getViewDirection().getY() < 0.0 ? 1.0 : -1.0, 0.0, 0.0, 0.0);
                this.vTranslation = new Vector4D(0.0, 0.0, view.getViewDirectionNormal().getZ(), 0.0);
                this.uMask = 1;
                this.vMask = 4;
            } else {
                this.setXAxisEnabled(false);
                this.uTranslation = new Vector4D(0.0, 0.0, view.getViewDirection().getY() < 0.0 ? -1.0 : 1.0, 0.0);
                this.vTranslation = new Vector4D(0.0, view.getViewDirectionNormal().getY(), 0.0);
                this.uMask = 4;
                this.vMask = 2;
            }
            this.allowedAxisIntersectionMask = this.uMask | this.vMask;
        }
    }
}

