/*
 * Decompiled with CFR 0.152.
 */
package viewer.deprecated;

import javax.media.opengl.GL;
import javax.swing.JOptionPane;
import rnadesign.rnacontrol.LinkController;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnamodel.Atom3D;
import rnadesign.rnamodel.BranchDescriptor3D;
import rnadesign.rnamodel.KissingLoop3D;
import rnadesign.rnamodel.Nucleotide3D;
import rnadesign.rnamodel.RnaStem3D;
import rnadesign.rnamodel.RnaStrand;
import rnadesign.rnamodel.StrandJunction3D;
import tools3d.Matrix4D;
import tools3d.Vector4D;
import tools3d.objects3d.Link;
import tools3d.objects3d.Object3D;
import viewer.deprecated.RNAModelRenderer;
import viewer.graphics.ColorModel;
import viewer.graphics.Colorable;
import viewer.graphics.Configurable;
import viewer.graphics.Material;
import viewer.graphics.Mesh;
import viewer.graphics.MeshRenderer;
import viewer.graphics.PrimitiveFactory;
import viewer.graphics.SolidMeshRenderer;
import viewer.graphics.WireframeMeshRenderer;
import viewer.util.Tools;

public class StickRenderer
implements RNAModelRenderer,
Colorable,
Configurable {
    private Object3DGraphController controller;
    private ColorModel colorModel;
    private boolean wireframeMode = false;
    private static final Mesh CYLINDER = PrimitiveFactory.generateCylinder(new Vector4D(1.0, 0.0, 0.0, 0.0), 0.5, 2.0, 1, 8);
    private RenderMode renderMode;

    public StickRenderer(Object3DGraphController controller) {
        this.controller = controller;
        this.renderMode = RenderMode.Cylinder;
    }

    public StickRenderer() {
        this(null);
    }

    public RenderMode getRenderMode() {
        return this.renderMode;
    }

    public void setRenderMode(RenderMode renderMode) {
        this.renderMode = renderMode;
    }

    @Override
    public Object3DGraphController getController() {
        return this.controller;
    }

    @Override
    public boolean getRenderAtom() {
        return false;
    }

    @Override
    public boolean getRenderBranchDescriptor() {
        return false;
    }

    @Override
    public boolean getRenderKissingLoop() {
        return false;
    }

    @Override
    public boolean getRenderLinks() {
        return true;
    }

    @Override
    public boolean getRenderNucleotide() {
        return false;
    }

    @Override
    public boolean getRenderOther() {
        return false;
    }

    @Override
    public boolean getRenderRNAStem() {
        return false;
    }

    @Override
    public boolean getRenderStrand() {
        return false;
    }

    @Override
    public boolean getRenderStrandJunction() {
        return false;
    }

    @Override
    public void renderAtom(Atom3D atom, GL gl) {
    }

    @Override
    public void renderBranchDescriptor(BranchDescriptor3D bd, GL gl) {
    }

    @Override
    public void renderKissingLoop(KissingLoop3D kl, GL gl) {
    }

    @Override
    public void launchConfigurationGUI() {
        Object result = JOptionPane.showInputDialog(null, "Select Rendering Mode", "Rendering Modes", -1, null, (Object[])RenderMode.values(), (Object)this.renderMode);
        if (result != null) {
            this.renderMode = (RenderMode)((Object)result);
        }
    }

    @Override
    public void renderLink(Link link, GL gl) {
        Material material = this.colorModel.getMaterial(link);
        gl.glMaterialfv(1028, 4608, material.getAmbient().buffer());
        gl.glMaterialfv(1028, 4609, material.getDiffuse().buffer());
        gl.glMaterialfv(1028, 4610, material.getSpecular().buffer());
        gl.glMaterialfv(1028, 5632, material.getEmissive().buffer());
        gl.glMaterialf(1028, 5633, (float)material.getHighlight());
        Object3D o1 = link.getObj1();
        Object3D o2 = link.getObj2();
        switch (this.renderMode) {
            case Cylinder: {
                Vector4D axis = new Vector4D(o1.getPosition().minus(o2.getPosition()));
                double length = axis.length() / 2.0;
                Vector4D midpoint = new Vector4D(o1.getPosition().plus(o2.getPosition()));
                midpoint = midpoint.mul(0.5);
                midpoint.setW(1.0);
                axis.setW(0.0);
                axis.normalize();
                MeshRenderer renderer = this.wireframeMode ? new WireframeMeshRenderer(CYLINDER) : new SolidMeshRenderer(CYLINDER);
                gl.glEnable(2977);
                gl.glPushMatrix();
                gl.glTranslated(midpoint.getX(), midpoint.getY(), midpoint.getZ());
                Vector4D rotationAxis = axis.cross(Tools.X_AXIS);
                double angle = Math.acos(axis.dot(Tools.X_AXIS));
                rotationAxis.normalize();
                Matrix4D rotation = Tools.getRotationMatrix(rotationAxis, angle);
                double[] matrix = rotation.getArray();
                gl.glMultMatrixd(matrix, 0);
                gl.glScaled(length, 1.0, 1.0);
                renderer.render(gl);
                gl.glPopMatrix();
                gl.glDisable(2977);
                break;
            }
            case Capsule: 
            case Line: {
                gl.glBegin(1);
                gl.glVertex3d(o1.getPosition().getX(), o1.getPosition().getY(), o1.getPosition().getZ());
                gl.glVertex3d(o2.getPosition().getX(), o2.getPosition().getY(), o2.getPosition().getZ());
                gl.glEnd();
            }
        }
    }

    @Override
    public void renderNucleotide(Nucleotide3D n, GL gl) {
    }

    @Override
    public void renderOther(Object3D o, GL gl) {
    }

    @Override
    public void renderRNAStem(RnaStem3D stem, GL gl) {
    }

    @Override
    public void renderRnaStrand(RnaStrand strand, GL gl) {
    }

    @Override
    public void renderSelected(Object3D o, GL gl) {
    }

    @Override
    public void renderStrandJunction(StrandJunction3D sj, GL gl) {
    }

    @Override
    public void setController(Object3DGraphController controller) {
    }

    @Override
    public void setWireframeMode(boolean wireframeMode) {
        this.wireframeMode = wireframeMode;
    }

    @Override
    public void render(GL gl) {
        gl.glLineWidth(2.0f);
        LinkController linkController = this.controller.getLinks();
        for (int i = 0; i < linkController.size(); ++i) {
            this.renderLink(linkController.get(i), gl);
        }
    }

    @Override
    public ColorModel getColorModel() {
        return this.colorModel;
    }

    @Override
    public void setColorModel(ColorModel model) {
        this.colorModel = model;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static enum RenderMode {
        Line,
        Cylinder,
        Capsule;

    }
}

