/*
 * Decompiled with CFR 0.152.
 */
package viewer.display;

import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLJPanel;
import tools3d.Vector4D;
import viewer.components.ViewManipulator;
import viewer.display.MultiDisplay;
import viewer.graphics.Gizmo;
import viewer.graphics.Gizmoable;
import viewer.graphics.RenderableAggregator;
import viewer.graphics.RenderableModel;
import viewer.view.OrthogonalView;

public abstract class Display
extends GLJPanel
implements Gizmoable,
RenderableAggregator {
    private MultiDisplay owner = null;
    private Color xAxisColor = Color.green;
    private Color yAxisColor = Color.red;
    private Color zAxisColor = Color.blue;
    private boolean lighting = true;
    private boolean mouseTranslationEnabled = true;
    private Gizmo gizmo;
    private boolean gizmoEnabled = false;
    private boolean gridVisible = true;
    private Color gridColor = new Color(102, 153, 255, 127);
    private double gridSize = 10.0;
    private double viewDistance = 2000.0;
    private boolean renderCoordinateAxis = true;
    private RenderableModel model = null;
    private ArrayList<RenderableModel> renderables = new ArrayList();

    public Display() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                Display.this.requestFocusInWindow();
            }
        });
    }

    @Override
    public void setGizmo(Gizmo gizmo) {
        if (this.gizmo != null) {
            this.removeMouseListener(this.gizmo.getMouseListener());
            this.removeMouseMotionListener(this.gizmo.getMouseMotionListener());
        }
        this.gizmo = gizmo;
        if (this.gizmo == null) {
            this.gizmoEnabled = false;
        } else {
            this.gizmo.setDisplay(this);
            this.addMouseListener(gizmo.getMouseListener());
            this.addMouseMotionListener(gizmo.getMouseMotionListener());
        }
    }

    @Override
    public Gizmo getGizmo() {
        return this.gizmo;
    }

    @Override
    public boolean isGizmoEnabled() {
        return this.gizmoEnabled;
    }

    @Override
    public void setGizmoEnabled(boolean gizmoEnabled) {
        if (this.gizmo != null) {
            this.gizmoEnabled = gizmoEnabled;
        }
    }

    public boolean isMouseTranslationEnabled() {
        return this.mouseTranslationEnabled;
    }

    public void setMouseTranslationEnabled(boolean mouseTranslationEnabled) {
        this.mouseTranslationEnabled = mouseTranslationEnabled;
    }

    public void setOwner(MultiDisplay owner) {
        this.owner = owner;
    }

    public MultiDisplay getOwner() {
        return this.owner;
    }

    public void setLighting(boolean lighting) {
        int result;
        this.lighting = lighting;
        GLContext context = this.getContext();
        if (context != null && (result = context.makeCurrent()) == 1) {
            GL gl = context.getGL();
            if (lighting) {
                gl.glEnable(2896);
            } else {
                gl.glDisable(2896);
            }
        }
    }

    public boolean getLighting() {
        return this.lighting;
    }

    public void setModel(RenderableModel model) {
        if (this.model != null) {
            this.renderables.remove(this.model);
        }
        this.model = model;
        if (model != null) {
            this.renderables.add(model);
        }
    }

    public void setModel(RenderableModel model, boolean add) {
        if (add) {
            this.setModel(model);
        } else {
            this.model = model;
        }
    }

    public RenderableModel getModel() {
        return this.model;
    }

    public boolean isRenderCoordinateAxis() {
        return this.renderCoordinateAxis;
    }

    public void setRenderCoordinateAxis(boolean renderCoordinateAxis) {
        this.renderCoordinateAxis = renderCoordinateAxis;
    }

    public abstract ViewManipulator.ZoomListener getZoomListener();

    public abstract ViewManipulator.RotateListener getRotateListener();

    public abstract ViewManipulator.TranslateListener getTranslateListener();

    public abstract void setZoomListener(ViewManipulator.ZoomListener var1);

    public abstract void setRotateListener(ViewManipulator.RotateListener var1);

    public abstract void setTranslateListener(ViewManipulator.TranslateListener var1);

    public Color getGridColor() {
        return this.gridColor;
    }

    public void setGridColor(Color gridColor) {
        this.gridColor = gridColor;
    }

    public double getGridSize() {
        return this.gridSize;
    }

    public abstract OrthogonalView getView();

    public boolean isGridVisible() {
        return this.gridVisible;
    }

    public void setGridVisible(boolean gridVisible) {
        this.gridVisible = gridVisible;
    }

    public double getViewDistance() {
        return this.viewDistance;
    }

    public void setGridSize(double gridSize) {
        this.gridSize = gridSize;
    }

    public void setViewDistance(double viewDistance) {
        this.viewDistance = viewDistance;
    }

    @Override
    public List<RenderableModel> getRenderables() {
        return this.renderables;
    }

    @Override
    public void addRenderable(Collection<RenderableModel> models) {
        this.renderables.addAll(models);
    }

    @Override
    public void addRenderable(RenderableModel model) {
        this.renderables.add(model);
        this.display();
    }

    @Override
    public boolean removeRenderable(RenderableModel model) {
        return this.renderables.remove(model);
    }

    @Override
    public void removeAllRenderables() {
        this.renderables.clear();
    }

    public abstract Vector4D getCoordinates(Point var1);

    public Color getXAxisColor() {
        return this.xAxisColor;
    }

    public void setXAxisColor(Color axisColor) {
        this.xAxisColor = axisColor;
    }

    public Color getYAxisColor() {
        return this.yAxisColor;
    }

    public void setYAxisColor(Color axisColor) {
        this.yAxisColor = axisColor;
    }

    public Color getZAxisColor() {
        return this.zAxisColor;
    }

    public void setZAxisColor(Color axisColor) {
        this.zAxisColor = axisColor;
    }

    public void setGLBackground(Color bg) {
        int result;
        super.setBackground(bg);
        GLContext context = this.getContext();
        if (context != null && (result = context.makeCurrent()) == 1) {
            GL gl = context.getGL();
            float[] fogColor = new float[]{(float)bg.getRed() / 255.0f, (float)bg.getGreen() / 255.0f, (float)bg.getBlue() / 255.0f, 1.0f};
            gl.glFogfv(2918, FloatBuffer.wrap(fogColor));
            gl.glClearColor(fogColor[0], fogColor[1], fogColor[2], 0.0f);
        }
    }

    public Color getGLBackground() {
        return this.getBackground();
    }
}

