/*
 * Decompiled with CFR 0.152.
 */
package viewer.display;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import viewer.display.Display;
import viewer.display.PerspectiveDisplay;
import viewer.graph.rna.RnaRendererGraphController;
import viewer.graphics.LODCapable;

public class DisplayOptions
extends JDialog {
    private Display display;
    private static final String LOD_COARSE = "Coarse";
    private static final String LOD_MEDIUM = "Medium";
    private static final String LOD_FINE = "Fine";

    public DisplayOptions(Display display) throws HeadlessException {
        super((Frame)null, "Display Options", true);
        this.display = display;
    }

    public void createAndShowGUI() {
        this.setDefaultCloseOperation(2);
        JTabbedPane pane = new JTabbedPane();
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        final JColorChooser backgroundChooser = new JColorChooser(this.display.getBackground());
        backgroundChooser.getSelectionModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DisplayOptions.this.display.setGLBackground(backgroundChooser.getColor());
                DisplayOptions.this.display.display();
            }
        });
        backgroundChooser.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Background Color", 1, 2));
        panel.add(backgroundChooser);
        pane.addTab("Background", panel);
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        final JColorChooser gridChooser = new JColorChooser(this.display.getGridColor());
        gridChooser.getSelectionModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DisplayOptions.this.display.setGridColor(gridChooser.getColor());
                DisplayOptions.this.display.display();
            }
        });
        JPanel flow = new JPanel();
        JLabel label = new JLabel("Grid spacing");
        flow.add(label);
        final JTextField sizeField = new JTextField(5);
        sizeField.setEditable(false);
        sizeField.setText("" + this.display.getGridSize());
        final JSlider gridSize = new JSlider();
        gridSize.setMinimum(1);
        gridSize.setMaximum(100);
        gridSize.setSnapToTicks(true);
        gridSize.setPaintLabels(false);
        gridSize.setPaintTicks(true);
        gridSize.setMajorTickSpacing(10);
        gridSize.setMinorTickSpacing(5);
        gridSize.setValue((int)this.display.getGridSize());
        gridSize.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (gridSize.getValueIsAdjusting()) {
                    return;
                }
                double size = gridSize.getValue();
                DisplayOptions.this.display.setGridSize(size);
                sizeField.setText("" + size);
                DisplayOptions.this.display.display();
            }
        });
        flow.add(gridSize);
        flow.add(sizeField);
        gridChooser.setEnabled(this.display.isGridVisible());
        gridChooser.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Background Color", 1, 2));
        gridChooser.setAlignmentX(0.0f);
        final JCheckBox gridEnabled = new JCheckBox("Grid Visible");
        gridEnabled.setSelected(this.display.isGridVisible());
        gridEnabled.setAlignmentX(0.0f);
        gridEnabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DisplayOptions.this.display.setGridVisible(gridEnabled.isSelected());
                gridChooser.setEnabled(gridEnabled.isSelected());
                gridSize.setEnabled(gridEnabled.isSelected());
                sizeField.setEnabled(gridEnabled.isSelected());
                DisplayOptions.this.display.display();
            }
        });
        panel.add(gridEnabled);
        panel.add(Box.createVerticalStrut(15));
        flow.setAlignmentX(0.0f);
        panel.add(flow);
        panel.add(Box.createVerticalStrut(15));
        panel.add(gridChooser);
        pane.addTab("Grid", panel);
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        flow = new JPanel();
        flow.setLayout(new BoxLayout(flow, 0));
        label = new JLabel("Graphical Detail");
        flow.add(label);
        flow.add(Box.createHorizontalStrut(15));
        Object[] objects = new Object[]{LOD_COARSE, LOD_MEDIUM, LOD_FINE};
        final JComboBox<Object> lodBox = new JComboBox<Object>(objects);
        lodBox.setEditable(false);
        lodBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object selected = lodBox.getSelectedItem();
                RnaRendererGraphController lod = (RnaRendererGraphController)DisplayOptions.this.display.getModel();
                if (selected == DisplayOptions.LOD_COARSE) {
                    lod.setRefinementLevel(1);
                } else if (selected == DisplayOptions.LOD_MEDIUM) {
                    lod.setRefinementLevel(2);
                } else {
                    lod.setRefinementLevel(3);
                }
                lod.updateMeshes();
                DisplayOptions.this.display.display();
            }
        });
        if (this.display.getModel() instanceof LODCapable) {
            RnaRendererGraphController lod = (RnaRendererGraphController)this.display.getModel();
            int refinement = lod.getRefinementLevel();
            if (refinement == 1) {
                lodBox.setSelectedIndex(0);
            } else if (refinement == 2) {
                lodBox.setSelectedIndex(1);
            } else {
                lodBox.setSelectedIndex(2);
            }
        } else {
            lodBox.setEnabled(false);
        }
        flow.add(lodBox);
        flow.setAlignmentX(0.0f);
        panel.add(flow);
        final JCheckBox lighting = new JCheckBox("Lighting Enabled");
        lighting.setSelected(this.display.getLighting());
        lighting.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DisplayOptions.this.display.setLighting(lighting.isSelected());
                DisplayOptions.this.display.display();
            }
        });
        panel.add(Box.createVerticalStrut(15));
        panel.add(lighting);
        final JCheckBox depthCue = new JCheckBox("Depth Cue Enabled (fog effect)");
        depthCue.setSelected(((PerspectiveDisplay)this.display).getFog());
        depthCue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((PerspectiveDisplay)DisplayOptions.this.display).setFog(depthCue.isSelected());
                DisplayOptions.this.display.display();
            }
        });
        panel.add(depthCue);
        panel.add(Box.createVerticalGlue());
        JPanel temp = new JPanel();
        temp.setLayout(new BoxLayout(temp, 1));
        panel.add(temp);
        temp = new JPanel();
        temp.setLayout(new BoxLayout(temp, 1));
        temp.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Selective Rendering", 1, 2));
        final JCheckBox renderStrands = new JCheckBox("Render Strands");
        final JCheckBox renderNucleotides = new JCheckBox("Render Nucleotides");
        final JCheckBox renderAtoms = new JCheckBox("Render Atoms");
        final JCheckBox renderLinks = new JCheckBox("Render Links");
        final JCheckBox renderBranchDescriptors = new JCheckBox("Render helix end descriptors");
        renderStrands.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RnaRendererGraphController rna = (RnaRendererGraphController)DisplayOptions.this.display.getModel();
                rna.setRenderStrands(renderStrands.isSelected());
                DisplayOptions.this.display.display();
            }
        });
        renderNucleotides.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RnaRendererGraphController rna = (RnaRendererGraphController)DisplayOptions.this.display.getModel();
                rna.setRenderNucleotides(renderNucleotides.isSelected());
                DisplayOptions.this.display.display();
            }
        });
        renderBranchDescriptors.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RnaRendererGraphController rna = (RnaRendererGraphController)DisplayOptions.this.display.getModel();
                rna.setRenderBranchDescriptors(renderBranchDescriptors.isSelected());
                DisplayOptions.this.display.display();
            }
        });
        renderAtoms.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RnaRendererGraphController rna = (RnaRendererGraphController)DisplayOptions.this.display.getModel();
                rna.setRenderAtoms(renderAtoms.isSelected());
                DisplayOptions.this.display.display();
            }
        });
        renderLinks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RnaRendererGraphController rna = (RnaRendererGraphController)DisplayOptions.this.display.getModel();
                rna.setRenderLinks(renderLinks.isSelected());
                DisplayOptions.this.display.display();
            }
        });
        if (this.display.getModel() instanceof RnaRendererGraphController) {
            RnaRendererGraphController rna = (RnaRendererGraphController)this.display.getModel();
            renderLinks.setSelected(rna.isRenderLinks());
            renderAtoms.setSelected(rna.isRenderAtoms());
            renderNucleotides.setSelected(rna.isRenderNucleotides());
            renderStrands.setSelected(rna.isRenderStrands());
            renderBranchDescriptors.setSelected(rna.isRenderBranchDescriptors());
        } else {
            renderLinks.setEnabled(false);
            renderAtoms.setEnabled(false);
            renderStrands.setEnabled(false);
            renderNucleotides.setEnabled(false);
            renderBranchDescriptors.setEnabled(false);
        }
        temp.add(renderStrands);
        temp.add(Box.createVerticalStrut(10));
        temp.add(renderNucleotides);
        temp.add(Box.createVerticalStrut(10));
        temp.add(renderAtoms);
        temp.add(Box.createVerticalStrut(10));
        temp.add(renderBranchDescriptors);
        temp.add(Box.createVerticalStrut(10));
        temp.add(renderLinks);
        panel.add(temp);
        pane.addTab("Rendering Options", panel);
        this.add((Component)pane, "Center");
        JPanel bottom = new JPanel();
        JButton close = new JButton("Close");
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DisplayOptions.this.setVisible(false);
                DisplayOptions.this.dispose();
            }
        });
        bottom.add(close);
        this.add((Component)bottom, "South");
        this.pack();
        this.setVisible(true);
    }
}

