/*
 * Decompiled with CFR 0.152.
 */
package viewer.display;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.glu.GLU;
import tools3d.Vector4D;
import viewer.components.ViewManipulator;
import viewer.display.Display;
import viewer.event.ViewEvent;
import viewer.event.ViewListener;
import viewer.graphics.Material;
import viewer.graphics.Mesh;
import viewer.graphics.PrimitiveFactory;
import viewer.graphics.RenderableModel;
import viewer.graphics.WireframeMeshRenderer;
import viewer.util.Tools;
import viewer.view.OrthogonalView;

public class OrthogonalDisplay
extends Display {
    private OrthogonalView view;
    private Mesh grid;
    private ViewManipulator.ZoomListener zoomListener;
    private ViewManipulator.TranslateListener translateListener;

    public OrthogonalDisplay(OrthogonalView view) {
        this.view = view;
        OrthogonalDisplayRenderer listener = new OrthogonalDisplayRenderer();
        this.addGLEventListener(listener);
        this.setBackground(Color.black);
        view.addViewListener(new ViewListener(){

            @Override
            public void viewChanged(ViewEvent e) {
                OrthogonalDisplay.this.display();
            }
        });
        this.grid = PrimitiveFactory.generateSheet(view.getViewDirection().mul(-1.0), 500.0, 500.0, (int)(500.0 / this.getGridSize()), (int)(500.0 / this.getGridSize()));
        ViewManipulator manipulator = new ViewManipulator(this.getView());
        this.zoomListener = manipulator.new ViewManipulator.ZoomListener();
        this.translateListener = manipulator.new ViewManipulator.TranslateListener();
        this.addMouseListener(this.zoomListener);
        this.addMouseMotionListener(this.zoomListener);
        this.addMouseListener(this.translateListener);
        this.addMouseMotionListener(this.translateListener);
    }

    public OrthogonalDisplay(OrthogonalView view, RenderableModel model) {
        this(view);
        this.setModel(model);
    }

    @Override
    public void setMouseTranslationEnabled(boolean mouseTranslationEnabled) {
        boolean oldMode = this.isMouseTranslationEnabled();
        super.setMouseTranslationEnabled(mouseTranslationEnabled);
        if (mouseTranslationEnabled && !oldMode) {
            this.addMouseListener(this.zoomListener);
            this.addMouseMotionListener(this.zoomListener);
            this.addMouseListener(this.translateListener);
            this.addMouseMotionListener(this.translateListener);
        } else if (!mouseTranslationEnabled && oldMode) {
            this.removeMouseListener(this.zoomListener);
            this.removeMouseMotionListener(this.zoomListener);
            this.removeMouseListener(this.translateListener);
            this.removeMouseMotionListener(this.translateListener);
        }
    }

    @Override
    public ViewManipulator.ZoomListener getZoomListener() {
        return this.zoomListener;
    }

    @Override
    public ViewManipulator.RotateListener getRotateListener() {
        return null;
    }

    @Override
    public ViewManipulator.TranslateListener getTranslateListener() {
        return this.translateListener;
    }

    @Override
    public void setZoomListener(ViewManipulator.ZoomListener listener) {
        if (this.zoomListener != null) {
            this.removeMouseListener(this.zoomListener);
            this.removeMouseMotionListener(this.zoomListener);
            this.zoomListener = listener;
            if (this.zoomListener != null) {
                this.addMouseListener(this.zoomListener);
                this.addMouseMotionListener(this.zoomListener);
            }
        }
    }

    @Override
    public void setRotateListener(ViewManipulator.RotateListener listener) {
    }

    @Override
    public void setTranslateListener(ViewManipulator.TranslateListener listener) {
        if (this.translateListener != null) {
            this.removeMouseListener(this.translateListener);
            this.removeMouseMotionListener(this.translateListener);
            this.translateListener = listener;
            if (this.translateListener != null) {
                this.addMouseListener(this.translateListener);
                this.addMouseMotionListener(this.translateListener);
            }
        }
    }

    @Override
    public OrthogonalView getView() {
        return this.view;
    }

    @Override
    public void setGridSize(double gridSize) {
        super.setGridSize(gridSize);
        this.grid = PrimitiveFactory.generateSheet(this.view.getViewDirection().mul(-1.0), 500.0, 500.0, (int)(500.0 / gridSize), (int)(500.0 / gridSize));
    }

    public void setView(OrthogonalView view) {
        this.view = view;
        this.grid = PrimitiveFactory.generateSheet(view.getViewDirection().mul(-1.0), 500.0, 500.0, (int)(500.0 / this.getGridSize()), (int)(500.0 / this.getGridSize()));
        this.display();
    }

    @Override
    public Vector4D getCoordinates(Point p) {
        Vector4D ray = new Vector4D(0.0, 0.0, 0.0, 0.0);
        Vector4D origin = new Vector4D(0.0, 0.0, 0.0, 1.0);
        Tools.screenTo3DSpace(p, this, ray, origin);
        Vector4D direction = this.getView().getViewDirection();
        Vector4D position = new Vector4D(0.0, 0.0, 0.0, 1.0);
        if (direction.getX() == 0.0) {
            position.setX(origin.getX());
        }
        if (direction.getY() == 0.0) {
            position.setY(origin.getY());
        }
        if (direction.getZ() == 0.0) {
            position.setZ(origin.getZ());
        }
        return position;
    }

    public class OrthogonalDisplayRenderer
    implements GLEventListener {
        @Override
        public void display(GLAutoDrawable d) {
            Material material;
            GL gl = d.getGL();
            gl.glClear(16640);
            gl.glMatrixMode(5889);
            gl.glLoadIdentity();
            Dimension screenSize = OrthogonalDisplay.this.getSize();
            double zoom = OrthogonalDisplay.this.view.getZoom();
            gl.glOrtho((double)(-1 * screenSize.width / 2) / zoom, (double)(screenSize.width / 2) / zoom, (double)(screenSize.height / 2) / zoom * -1.0, (double)screenSize.height / zoom / 2.0, -OrthogonalDisplay.this.getViewDistance(), OrthogonalDisplay.this.getViewDistance());
            gl.glMatrixMode(5888);
            gl.glLoadIdentity();
            GLU glu = new GLU();
            Vector4D eye = OrthogonalDisplay.this.view.getViewLocation();
            Vector4D lookAt = OrthogonalDisplay.this.view.getViewDirection();
            Vector4D up = OrthogonalDisplay.this.view.getViewDirectionNormal();
            glu.gluLookAt(eye.getX(), eye.getY(), eye.getZ(), eye.getX() + lookAt.getX(), eye.getY() + lookAt.getY(), eye.getZ() + lookAt.getZ(), up.getX(), up.getY(), up.getZ());
            for (RenderableModel m : OrthogonalDisplay.this.getRenderables()) {
                m.render(gl);
            }
            if (OrthogonalDisplay.this.isGizmoEnabled()) {
                OrthogonalDisplay.this.getGizmo().render(gl);
            }
            if (OrthogonalDisplay.this.isRenderCoordinateAxis()) {
                gl.glBegin(1);
                Vector4D direction = OrthogonalDisplay.this.view.getViewDirection();
                if (direction.getX() == 0.0) {
                    material = new Material(OrthogonalDisplay.this.getXAxisColor());
                    Material.renderMaterial(gl, material);
                    gl.glVertex3d(-250.0, 0.0, 0.0);
                    gl.glVertex3d(250.0, 0.0, 0.0);
                }
                if (direction.getY() == 0.0) {
                    material = new Material(OrthogonalDisplay.this.getYAxisColor());
                    Material.renderMaterial(gl, material);
                    gl.glVertex3d(0.0, -250.0, 0.0);
                    gl.glVertex3d(0.0, 250.0, 0.0);
                }
                if (direction.getZ() == 0.0) {
                    material = new Material(OrthogonalDisplay.this.getZAxisColor());
                    Material.renderMaterial(gl, material);
                    gl.glVertex3d(0.0, 0.0, -250.0);
                    gl.glVertex3d(0.0, 0.0, 250.0);
                }
                gl.glEnd();
            }
            if (OrthogonalDisplay.this.isGridVisible()) {
                gl.glLineWidth(0.5f);
                WireframeMeshRenderer renderer = new WireframeMeshRenderer(OrthogonalDisplay.this.grid);
                material = new Material(OrthogonalDisplay.this.getGridColor());
                Material.renderMaterial(gl, material);
                renderer.render(gl);
            }
        }

        @Override
        public void displayChanged(GLAutoDrawable d, boolean arg1, boolean arg2) {
        }

        @Override
        public void init(GLAutoDrawable d) {
            GL gl = d.getGL();
            if (OrthogonalDisplay.this.getLighting()) {
                float[] ambient = new float[]{0.2f, 0.2f, 0.2f, 1.0f};
                float[] specular = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
                float[] position = new float[]{0.0f, 0.0f, 1.0f, 0.0f};
                float[] ambientModel = new float[]{0.1f, 0.1f, 0.1f, 0.1f};
                gl.glLightfv(16384, 4608, ambient, 0);
                gl.glLightfv(16384, 4610, specular, 0);
                gl.glLightfv(16384, 4611, position, 0);
                gl.glLightModelfv(2899, ambientModel, 0);
                gl.glEnable(16384);
                gl.glEnable(2896);
            }
            Color bg = OrthogonalDisplay.this.getGLBackground();
            gl.glEnableClientState(32884);
            gl.glEnableClientState(32885);
            gl.glEnable(2929);
            gl.glClearColor((float)bg.getRed() / 255.0f, (float)bg.getGreen() / 255.0f, (float)bg.getBlue() / 255.0f, 0.0f);
            gl.glEnable(3042);
            gl.glBlendEquation(32774);
        }

        @Override
        public void reshape(GLAutoDrawable d, int x, int y, int width, int height) {
            GL gl = d.getGL();
            double zoom = OrthogonalDisplay.this.view.getZoom();
            gl.glMatrixMode(5889);
            gl.glLoadIdentity();
            Dimension screenSize = OrthogonalDisplay.this.getSize();
            gl.glOrtho((double)(-1 * screenSize.width / 2) / zoom, (double)(screenSize.width / 2) / zoom, (double)(screenSize.height / 2) / zoom * -1.0, (double)screenSize.height / zoom / 2.0, -OrthogonalDisplay.this.getViewDistance(), OrthogonalDisplay.this.getViewDistance());
            gl.glViewport(0, 0, screenSize.width, screenSize.height);
        }
    }
}

