/*
 * Decompiled with CFR 0.152.
 */
package viewer.graph;

import java.awt.Color;
import javax.media.opengl.GL;
import rnadesign.rnamodel.Atom3D;
import tools3d.Matrix4D;
import tools3d.Vector4D;
import tools3d.objects3d.Link;
import tools3d.objects3d.Object3D;
import viewer.graph.GeometryRenderableGraph;
import viewer.graphics.ColorModel;
import viewer.graphics.ColorVector;
import viewer.graphics.Colorable;
import viewer.graphics.Material;
import viewer.graphics.Mesh;
import viewer.graphics.MeshRenderer;
import viewer.graphics.PrimitiveFactory;
import viewer.graphics.SolidMeshRenderer;
import viewer.graphics.WireframeMeshRenderer;
import viewer.util.Tools;

public class LinkRenderableGraph
extends GeometryRenderableGraph
implements Colorable {
    private static final Mesh CYLINDER = PrimitiveFactory.generateCylinder(new Vector4D(1.0, 0.0, 0.0, 0.0), 0.5, 2.0, 1, 8);
    private RenderMode renderMode = RenderMode.Line;
    private Link link;
    private ColorModel model;
    private Color linkColor = Color.white;

    public LinkRenderableGraph(Link link) {
        this.link = link;
    }

    @Override
    public void render(GL gl) {
        this.renderLink(this.link, gl);
    }

    public RenderMode getRenderMode() {
        return this.renderMode;
    }

    public Color getLinkColor() {
        return this.linkColor;
    }

    private Color getCovalentBondLinkColor(Link link) {
        assert (link.getObj1() instanceof Atom3D);
        assert (link.getObj2() instanceof Atom3D);
        Atom3D atom1 = (Atom3D)link.getObj1();
        Atom3D atom2 = (Atom3D)link.getObj2();
        Material m1 = this.getColorModel().getAtomMaterial(atom1);
        Material m2 = this.getColorModel().getAtomMaterial(atom2);
        ColorVector ambient1 = m1.getAmbient();
        ColorVector ambient2 = m2.getAmbient();
        return this.getAverageColor(ambient1.getAWTColor(), ambient2.getAWTColor());
    }

    private Color getAverageColor(Color color1, Color color2) {
        double blue = (double)(color1.getBlue() + color2.getBlue()) / 2.0;
        double red = (double)(color1.getRed() + color2.getRed()) / 2.0;
        double green = (double)(color1.getGreen() + color2.getGreen()) / 2.0;
        double alpha = (double)(color1.getAlpha() + color2.getAlpha()) / 2.0;
        return new Color((int)red, (int)green, (int)blue, (int)alpha);
    }

    private boolean isCovalentBondLink(Link link) {
        return link.getObj1() instanceof Atom3D && link.getObj2() instanceof Atom3D;
    }

    public Color getLinkColor(Link link) {
        if (this.isCovalentBondLink(link)) {
            return this.getCovalentBondLinkColor(link);
        }
        return this.linkColor;
    }

    public void renderLink(Link l, GL gl) {
        Object3D o1 = l.getObj1();
        Object3D o2 = l.getObj2();
        Material material = new Material(this.getLinkColor(l), true);
        Material.renderMaterial(gl, material);
        switch (this.getRenderMode()) {
            case Cylinder: {
                Vector4D axis = new Vector4D(o1.getPosition().minus(o2.getPosition()));
                double length = axis.length() / 2.0;
                Vector4D midpoint = new Vector4D(o1.getPosition().plus(o2.getPosition()));
                midpoint = midpoint.mul(0.5);
                midpoint.setW(1.0);
                axis.setW(0.0);
                axis.normalize();
                MeshRenderer renderer = this.isWireframeMode() ? new WireframeMeshRenderer(CYLINDER) : new SolidMeshRenderer(CYLINDER);
                gl.glEnable(2977);
                gl.glPushMatrix();
                gl.glTranslated(midpoint.getX(), midpoint.getY(), midpoint.getZ());
                Vector4D rotationAxis = axis.cross(Tools.X_AXIS);
                double angle = Math.acos(axis.dot(Tools.X_AXIS));
                rotationAxis.normalize();
                Matrix4D rotation = Tools.getRotationMatrix(rotationAxis, angle);
                double[] matrix = rotation.getArray();
                gl.glMultMatrixd(matrix, 0);
                gl.glScaled(length, 1.0, 1.0);
                renderer.render(gl);
                gl.glPopMatrix();
                gl.glDisable(2977);
                break;
            }
            case Capsule: {
                break;
            }
            case Line: {
                gl.glBegin(1);
                gl.glVertex3d(o1.getPosition().getX(), o1.getPosition().getY(), o1.getPosition().getZ());
                gl.glVertex3d(o2.getPosition().getX(), o2.getPosition().getY(), o2.getPosition().getZ());
                gl.glEnd();
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public Link getLink() {
        return this.link;
    }

    @Override
    public String getClassName() {
        return "LinkRenderableGraph";
    }

    @Override
    public ColorModel getColorModel() {
        return this.model;
    }

    @Override
    public void setColorModel(ColorModel model) {
        this.model = model;
    }

    public static enum RenderMode {
        Line,
        Cylinder,
        Capsule;

    }
}

