/*
 * Decompiled with CFR 0.152.
 */
package viewer.graph;

import javax.media.opengl.GL;
import viewer.graph.GeometryRenderableGraph;
import viewer.graph.RenderableGraph;
import viewer.graphics.ColorModel;
import viewer.graphics.Colorable;
import viewer.graphics.LODCapable;
import viewer.graphics.MeshCacheable;
import viewer.graphics.RenderableModel;

public class RenderableGraphController
implements LODCapable,
Colorable,
RenderableModel {
    private int refinementLevel = 1;
    private RenderableGraph root;
    private boolean meshCached;
    private ColorModel colorModel;
    private boolean wireframeMode = false;

    public RenderableGraph getRoot() {
        return this.root;
    }

    public void setRoot(RenderableGraph root) {
        this.root = root;
    }

    @Override
    public int getRefinementLevel() {
        return this.refinementLevel;
    }

    @Override
    public void setRefinementLevel(int refinementLevel) {
        this.refinementLevel = refinementLevel;
        this.setRefinementLevel(this.root);
    }

    private void setRefinementLevel(RenderableGraph graph) {
        if (graph instanceof LODCapable) {
            ((LODCapable)((Object)graph)).setRefinementLevel(this.refinementLevel);
        }
        for (int i = 0; i < graph.size(); ++i) {
            this.setRefinementLevel(graph.getChild(i));
        }
    }

    @Override
    public ColorModel getColorModel() {
        return this.colorModel;
    }

    @Override
    public void setColorModel(ColorModel model) {
        this.colorModel = model;
        this.setColorModel(this.root);
    }

    private void setColorModel(RenderableGraph graph) {
        if (graph instanceof Colorable) {
            ((Colorable)((Object)graph)).setColorModel(this.colorModel);
        }
        for (int i = 0; i < graph.size(); ++i) {
            this.setColorModel(graph.getChild(i));
        }
    }

    public boolean isMeshCached() {
        return this.meshCached;
    }

    public void setMeshCached(boolean meshCached) {
        this.meshCached = meshCached;
        this.setMeshCached(this.root);
    }

    private void setMeshCached(RenderableGraph root) {
        if (root instanceof MeshCacheable) {
            ((MeshCacheable)((Object)root)).setMeshCached(this.meshCached);
        }
        for (int i = 0; i < root.size(); ++i) {
            this.setMeshCached(root.getChild(i));
        }
    }

    @Override
    public void render(GL gl) {
        this.root.render(gl);
    }

    public void updateMeshes() {
        this.udpdateMeshes(this.root);
    }

    private void udpdateMeshes(RenderableGraph root) {
        if (root instanceof MeshCacheable) {
            ((MeshCacheable)((Object)root)).updateMesh();
        }
        for (int i = 0; i < root.size(); ++i) {
            this.udpdateMeshes(root.getChild(i));
        }
    }

    public void setWireframeMode(boolean wireframeMode) {
        this.wireframeMode = wireframeMode;
        this.setWireframeMode(this.root);
    }

    public boolean isWireframeMode() {
        return this.wireframeMode;
    }

    private void setWireframeMode(RenderableGraph graph) {
        if (graph instanceof GeometryRenderableGraph) {
            ((GeometryRenderableGraph)graph).setWireframeMode(this.wireframeMode);
        }
        for (int i = 0; i < graph.size(); ++i) {
            this.setWireframeMode(graph.getChild(i));
        }
    }
}

