/*
 * Decompiled with CFR 0.152.
 */
package viewer.graph;

import javax.media.opengl.GL;
import tools3d.Matrix4D;
import viewer.graph.RenderableGraphImp;

public class TransformGraph
extends RenderableGraphImp {
    private Matrix4D transform;

    public TransformGraph(Matrix4D transform) {
        this.transform = transform;
    }

    public Matrix4D getTransform() {
        return this.transform;
    }

    @Override
    public void render(GL gl) {
        gl.glPushMatrix();
        gl.glMultMatrixd(this.transform.getArray(), 0);
        super.render(gl);
        gl.glPopMatrix();
    }

    @Override
    public String getClassName() {
        return "TransformGraph";
    }

    @Override
    public Object clone() {
        TransformGraph graph = (TransformGraph)super.clone();
        graph.transform = new Matrix4D();
        graph.transform.copy(this.transform);
        return graph;
    }
}

