/*
 * Decompiled with CFR 0.152.
 */
package viewer.graph.rna;

import java.util.ArrayList;
import rnadesign.rnamodel.Residue3D;
import rnadesign.rnamodel.RnaStrand;
import tools3d.Vector3D;
import tools3d.Vector4D;
import tools3d.splines.StandaloneSplineFactory;
import viewer.graph.rna.BackboneRendererGraph;
import viewer.graphics.AdvancedMesh;
import viewer.graphics.AdvancedMeshTools;
import viewer.graphics.DefaultAdvancedMesh;
import viewer.graphics.Material;
import viewer.graphics.Mesh;
import viewer.graphics.MeshOperations;
import viewer.util.Tools;

public class RibbonBackboneRenderer
extends BackboneRendererGraph {
    public RibbonBackboneRenderer(RnaStrand strand, boolean cache) {
        super(strand, cache);
    }

    public RibbonBackboneRenderer(RnaStrand strand) {
        super(strand);
    }

    @Override
    public AdvancedMesh generateMesh() {
        RnaStrand strand = this.getStrand();
        ArrayList<Vector3D> backbone = new ArrayList<Vector3D>(strand.getResidueCount());
        ArrayList<Vector3D> orientations = new ArrayList<Vector3D>(strand.getResidueCount());
        for (int i = 0; i < strand.getResidueCount(); ++i) {
            Residue3D residue = strand.getResidue3D(i);
            if (residue.getIndexOfChild("O5*") >= 0) {
                Vector3D v;
                backbone.add(residue.getChild("O5*").getPosition());
                if ((residue.getSymbol().getCharacter() == 'G' || residue.getSymbol().getCharacter() == 'A') && residue.getIndexOfChild("N9") >= 0) {
                    v = residue.getChild("N9").getPosition().minus(residue.getChild("O5*").getPosition());
                    v.normalize();
                    orientations.add(v);
                    continue;
                }
                if (residue.getIndexOfChild("N1") < 0) continue;
                v = residue.getChild("N1").getPosition().minus(residue.getChild("O5*").getPosition());
                v.normalize();
                orientations.add(v);
                continue;
            }
            backbone.add(residue.getPosition());
        }
        Vector3D[] points = new Vector3D[backbone.size()];
        backbone.toArray(points);
        Vector3D[] o = new Vector3D[orientations.size()];
        orientations.toArray(o);
        StandaloneSplineFactory factory = new StandaloneSplineFactory();
        Vector3D[] curve = factory.createCubic(points, this.getRefinement());
        Vector4D[] polygon = new Vector4D[]{new Vector4D(1.0, 0.1, 0.0, 0.0), new Vector4D(0.0, 0.1, 0.0, 0.0), new Vector4D(-1.0, 0.1, 0.0, 0.0), new Vector4D(-1.0, -0.1, 0.0, 0.0), new Vector4D(0.0, -0.1, 0.0, 0.0), new Vector4D(1.0, -0.1, 0.0, 0.0)};
        Vector4D polygonNormal = new Vector4D(0.0, 0.0, -1.0, 0.0);
        Mesh mesh = null;
        if (o.length > 0) {
            Vector3D[] io = new Vector3D[curve.length];
            io[0] = o[0];
            for (int i = 0; i < o.length - 1; ++i) {
                io[(i + 1) * this.getRefinement()] = o[i + 1];
                Vector4D i1 = new Vector4D(o[i]);
                i1.setW(0.0);
                Vector4D i2 = new Vector4D(o[i + 1]);
                i2.setW(0.0);
                Vector4D axis = new Vector4D(i1.cross(i2));
                axis.setW(0.0);
                axis.normalize();
                double angle = Math.acos(i1.dot(i2));
                angle /= (double)(this.getRefinement() - 1);
                for (int j = 0; j < this.getRefinement() - 1; ++j) {
                    Vector4D ri = Tools.rotate(i1, axis, angle);
                    io[i * this.getRefinement() + j + 1] = new Vector3D(ri);
                    i1 = ri;
                    i1.normalize();
                }
            }
            Vector4D polygonOrientation = new Vector4D(0.0, 1.0, 0.0, 0.0);
            mesh = MeshOperations.extend(polygon, polygonNormal, polygonOrientation, curve, io);
        } else {
            mesh = MeshOperations.extend(polygon, polygonNormal, curve);
        }
        DefaultAdvancedMesh m = new DefaultAdvancedMesh();
        m.add(mesh, this.getColorModel().getMaterial(strand));
        if (this.getStrand().isSelected() && this.getRefinementLevel() != 1) {
            Material material = new Material();
            material.setEmissive(1.0, 1.0, 0.0, 0.0);
            DefaultAdvancedMesh combo = new DefaultAdvancedMesh();
            combo.add(m);
            combo.add(AdvancedMeshTools.extractCage(m, material));
            return combo;
        }
        return m;
    }

    private int getRefinement() {
        switch (this.getRefinementLevel()) {
            case 3: {
                return 8;
            }
            case 2: {
                return 6;
            }
        }
        return 4;
    }
}

