/*
 * Decompiled with CFR 0.152.
 */
package viewer.graph.rna;

import java.util.ArrayList;
import java.util.List;
import rnadesign.rnamodel.Atom3D;
import rnadesign.rnamodel.Nucleotide3D;
import rnadesign.rnamodel.NucleotideTools;
import tools3d.Vector4D;
import viewer.graph.rna.NucleotideRendererGraph;
import viewer.graphics.AdvancedMesh;
import viewer.graphics.AdvancedMeshTools;
import viewer.graphics.DefaultAdvancedMesh;
import viewer.graphics.Material;
import viewer.graphics.Mesh;
import viewer.graphics.MeshOperations;
import viewer.graphics.PrimitiveFactory;

public class StickNucleotideRendererGraph
extends NucleotideRendererGraph {
    public boolean atomLoopMode = false;
    private boolean renderSugar = true;
    private boolean renderPhosphate = true;
    private boolean renderBase = true;

    public StickNucleotideRendererGraph(Nucleotide3D n) {
        super(n);
    }

    public StickNucleotideRendererGraph(Nucleotide3D n, boolean renderSugar, boolean renderPhosphate, boolean renderBase) {
        this(n);
        this.renderSugar = renderSugar;
        this.renderPhosphate = renderPhosphate;
        this.renderBase = renderBase;
    }

    public StickNucleotideRendererGraph(Nucleotide3D n, boolean renderSugar, boolean renderPhosphate, boolean renderBase, boolean cache) {
        this(n, renderSugar, renderPhosphate, renderBase);
        this.setMeshCached(cache);
    }

    public StickNucleotideRendererGraph(Nucleotide3D n, boolean cache) {
        this(n);
        this.setMeshCached(cache);
    }

    @Override
    public AdvancedMesh generateMesh() {
        List<Atom3D> atoms = this.atomCollector();
        DefaultAdvancedMesh mesh = new DefaultAdvancedMesh();
        if (this.atomLoopMode) {
            for (int i = 0; i < atoms.size(); ++i) {
                for (int j = i + 1; j < atoms.size(); ++j) {
                    Atom3D a1 = atoms.get(i);
                    Atom3D a2 = atoms.get(j);
                    if (!NucleotideTools.isCovalentlyBonded(this.getNucleotide(), a1, a2)) continue;
                    Vector4D p1 = new Vector4D(a1.getPosition());
                    Vector4D p2 = new Vector4D(a2.getPosition());
                    if (this.getRefinementLevel() == 1) {
                        Material material = new Material(this.getColorModel().getColor(this.getNucleotide()), true);
                        DefaultAdvancedMesh am = new DefaultAdvancedMesh();
                        am.setLineWidth(3.0);
                        am.add(p1, new Vector4D(0.0, 0.0, -1.0, 0.0), material);
                        am.add(p2, new Vector4D(0.0, 0.0, -1.0, 0.0), material);
                        int[] line = new int[]{0, 1};
                        am.add(line);
                        mesh.add(am);
                        continue;
                    }
                    Vector4D axis = p2.minus(p1);
                    double length = axis.length();
                    axis.setW(0.0);
                    axis.normalize();
                    Mesh cylinder = PrimitiveFactory.generateCylinder(axis, 0.25, length, 1, this.getStickSubdivisions());
                    Vector4D midpoint = new Vector4D((p1.getX() + p2.getX()) / 2.0, (p1.getY() + p2.getY()) / 2.0, (p1.getZ() + p2.getZ()) / 2.0, 1.0);
                    cylinder = MeshOperations.translateMesh(cylinder, midpoint);
                    mesh.add(cylinder, this.getColorModel().getMaterial(this.getNucleotide()));
                }
            }
        }
        if (this.getNucleotide().isSelected() && this.getRefinementLevel() != 1) {
            Material material = new Material();
            material.setEmissive(1.0, 1.0, 0.0, 0.0);
            DefaultAdvancedMesh combo = new DefaultAdvancedMesh();
            combo.add(mesh);
            combo.add(AdvancedMeshTools.extractCage(mesh, material));
            return combo;
        }
        return mesh;
    }

    public void setAtomLoopMode(boolean atomLoopMode) {
        this.atomLoopMode = atomLoopMode;
    }

    public boolean isRenderBase() {
        return this.renderBase;
    }

    public void setRenderBase(boolean renderBase) {
        this.renderBase = renderBase;
        if (this.isMeshCached()) {
            this.updateMesh();
        }
    }

    public boolean isRenderPhosphate() {
        return this.renderPhosphate;
    }

    public void setRenderPhosphate(boolean renderPhosphate) {
        this.renderPhosphate = renderPhosphate;
        if (this.isMeshCached()) {
            this.updateMesh();
        }
    }

    public boolean isRenderSugar() {
        return this.renderSugar;
    }

    public void setRenderSugar(boolean renderSugar) {
        this.renderSugar = renderSugar;
        if (this.isMeshCached()) {
            this.updateMesh();
        }
    }

    private List<Atom3D> atomCollector() {
        ArrayList<Atom3D> atoms = new ArrayList<Atom3D>(this.getNucleotide().getAtomCount());
        for (int i = 0; i < this.getNucleotide().getAtomCount(); ++i) {
            Atom3D atom = this.getNucleotide().getAtom(i);
            if (this.renderSugar && NucleotideTools.isSugarAtom(atom)) {
                atoms.add(atom);
                continue;
            }
            if (this.renderPhosphate && NucleotideTools.isPhosphate(atom)) {
                atoms.add(atom);
                continue;
            }
            if (this.renderBase && NucleotideTools.isBaseAtom(atom)) {
                atoms.add(atom);
                continue;
            }
            if (!NucleotideTools.isBackboneAtom(atom)) continue;
            atoms.add(atom);
        }
        return atoms;
    }

    protected int getStickSubdivisions() {
        if (this.getRefinementLevel() == 2) {
            return 4;
        }
        if (this.getRefinementLevel() == 3) {
            return 6;
        }
        return 4;
    }
}

