/*
 * Decompiled with CFR 0.152.
 */
package viewer.graphics;

import java.util.ArrayList;
import javax.media.opengl.GL;
import tools3d.Vector4D;
import viewer.graphics.Mesh;
import viewer.graphics.MeshRenderer;

public class SolidMeshRenderer
implements MeshRenderer {
    private Mesh mesh;
    private ArrayList<Mesh> meshes = new ArrayList();

    @Override
    public void addMesh(Mesh m) {
        this.meshes.add(m);
    }

    @Override
    public boolean removeMesh(Mesh m) {
        return this.meshes.remove(m);
    }

    public SolidMeshRenderer() {
    }

    public SolidMeshRenderer(Mesh mesh) {
        this.meshes.add(mesh);
    }

    @Override
    public void render(GL gl) {
        for (Mesh mesh : this.meshes) {
            this.renderMesh(gl, mesh);
        }
    }

    protected void renderMesh(GL gl, Mesh mesh) {
        if (mesh.getPolygonSideCount() == 3) {
            gl.glBegin(4);
        } else if (mesh.getPolygonSideCount() == 4) {
            gl.glBegin(7);
        } else {
            gl.glBegin(9);
        }
        for (int i = 0; i < mesh.getGeometryElementCount(); ++i) {
            int[] triangle = mesh.getGeometryElement(i);
            for (int j = 0; j < triangle.length; ++j) {
                Vector4D p = mesh.getNormal(triangle[j]);
                gl.glNormal3d(p.getX(), p.getY(), p.getZ());
                p = mesh.getVertex(triangle[j]);
                gl.glVertex3d(p.getX(), p.getY(), p.getZ());
            }
        }
        gl.glEnd();
    }

    @Override
    public Mesh getMesh() {
        return this.mesh;
    }
}

