/*
 * Decompiled with CFR 0.152.
 */
package viewer.rnadesign;

import java.awt.Color;
import rnadesign.rnamodel.Atom3D;
import rnadesign.rnamodel.BranchDescriptor3D;
import rnadesign.rnamodel.KissingLoop3D;
import rnadesign.rnamodel.Nucleotide3D;
import rnadesign.rnamodel.RnaStem3D;
import rnadesign.rnamodel.RnaStrand;
import rnadesign.rnamodel.StrandJunction3D;
import tools3d.objects3d.Object3D;
import viewer.graphics.ColorModel;
import viewer.graphics.ColorVector;
import viewer.graphics.Material;

public abstract class RNAColorModel
implements ColorModel {
    @Override
    public Material getMaterial(Object3D o) {
        if (o instanceof BranchDescriptor3D) {
            return this.getBranchDescriptorMaterial((BranchDescriptor3D)o);
        }
        if (o instanceof Nucleotide3D) {
            return this.getNucleotideMaterial((Nucleotide3D)o);
        }
        if (o instanceof RnaStrand) {
            return this.getRnaStrandMaterial((RnaStrand)o);
        }
        if (o instanceof RnaStem3D) {
            return this.getRnaStemMaterial((RnaStem3D)o);
        }
        if (o instanceof BranchDescriptor3D) {
            return this.getBranchDescriptorMaterial((BranchDescriptor3D)o);
        }
        if (o instanceof StrandJunction3D) {
            return this.getStrandJunctionMaterial((StrandJunction3D)o);
        }
        if (o instanceof KissingLoop3D) {
            return this.getKissingLoopMaterial((KissingLoop3D)o);
        }
        if (o instanceof Atom3D) {
            return this.getAtomMaterial((Atom3D)o);
        }
        return this.getOtherMaterial(o);
    }

    @Override
    public Color getColor(Object3D o) {
        Material m = this.getMaterial(o);
        ColorVector v = m.getDiffuse();
        return new Color((int)(v.getRed() * 255.0), (int)(v.getGreen() * 255.0), (int)(v.getBlue() * 255.0));
    }

    @Override
    public void reset() {
    }

    public Material getDefaultMaterial() {
        return new Material(0.0, 0.0, 0.0, 0.0, 0.8, 0.8, 0.8, 1.0, 0.2, 0.2, 0.2, 1.0, 0.0, 0.0, 0.0, 1.0, 32.0);
    }

    @Override
    public abstract Material getAtomMaterial(Atom3D var1);

    public abstract Material getBranchDescriptorMaterial(BranchDescriptor3D var1);

    public abstract Material getNucleotideMaterial(Nucleotide3D var1);

    public abstract Material getRnaStrandMaterial(RnaStrand var1);

    public abstract Material getRnaStemMaterial(RnaStem3D var1);

    public abstract Material getKissingLoopMaterial(KissingLoop3D var1);

    public abstract Material getStrandJunctionMaterial(StrandJunction3D var1);

    public abstract Material getOtherMaterial(Object3D var1);
}

