/*
 * Decompiled with CFR 0.152.
 */
package viewer.view;

import tools3d.Matrix4D;
import tools3d.Vector4D;
import viewer.event.ViewListener;
import viewer.event.ViewListenerManager;
import viewer.util.Tools;
import viewer.view.PerspectiveView;

public class DefaultPerspectiveView
implements PerspectiveView {
    private Vector4D viewDirection = new Vector4D(0.0, 0.0, -1.0, 0.0);
    private Vector4D viewLocation = new Vector4D(0.0, 0.0, 0.0, 0.0);
    private Vector4D viewNormal = new Vector4D(0.0, 1.0, 0.0, 0.0);
    private Vector4D viewDirectionSaved;
    private Vector4D viewLocationSaved;
    private Vector4D viewNormalSaved;
    private ViewListenerManager manager = new ViewListenerManager();

    public DefaultPerspectiveView() {
        this(new Vector4D(0.0, 0.0, -1.0, 0.0), new Vector4D(0.0, 0.0, 0.0, 0.0), new Vector4D(0.0, 1.0, 0.0, 0.0));
    }

    public DefaultPerspectiveView(Vector4D viewDirection, Vector4D viewLocation, Vector4D viewNormal) {
        this.viewDirection = viewDirection;
        this.viewLocation = viewLocation;
        this.viewNormal = viewNormal;
        this.viewDirectionSaved = (Vector4D)viewDirection.clone();
        this.viewLocationSaved = (Vector4D)viewLocation.clone();
        this.viewNormalSaved = (Vector4D)viewNormal.clone();
    }

    @Override
    public void reset() {
        this.viewDirection = (Vector4D)this.viewDirectionSaved.clone();
        this.viewLocation = (Vector4D)this.viewLocationSaved.clone();
        this.viewNormal = (Vector4D)this.viewNormalSaved.clone();
    }

    @Override
    public Vector4D getViewDirectionNormal() {
        return this.viewNormal;
    }

    public ViewListenerManager getManager() {
        return this.manager;
    }

    @Override
    public void lookAt(double x, double y, double z) {
    }

    @Override
    public void rotateLocalViewX(double angle) {
        angle = angle * Math.PI / 180.0;
        Vector4D axis = this.viewNormal.cross(this.viewDirection);
        axis.normalize();
        Vector4D oldDirection = this.viewDirection;
        this.viewDirection = Tools.rotate(this.viewDirection, axis, angle);
        Vector4D oldNormal = this.viewNormal;
        this.viewNormal = Tools.rotate(this.viewNormal, axis, angle);
        this.manager.notifyViewRotation(true, oldDirection, oldNormal, this.viewDirection, this.viewNormal);
    }

    @Override
    public void addViewListener(ViewListener l) {
        this.manager.addViewListener(l);
    }

    public void removeViewListener(ViewListener l) {
        this.manager.removeViewListener(l);
    }

    @Override
    public void rotateLocalViewY(double angle) {
        angle = angle * Math.PI / 180.0;
        Vector4D oldDirection = this.viewDirection;
        this.viewDirection = Tools.rotate(this.viewDirection, this.viewNormal, angle);
        this.manager.notifyViewRotation(true, oldDirection, this.viewNormal, this.viewDirection, this.viewNormal);
    }

    @Override
    public void rotateLocalViewZ(double angle) {
        angle = angle * Math.PI / 180.0;
        Vector4D oldNormal = this.viewNormal;
        this.viewNormal = Tools.rotate(this.viewNormal, this.viewDirection, angle);
        this.manager.notifyViewRotation(true, this.viewDirection, oldNormal, this.viewDirection, this.viewNormal);
    }

    @Override
    public void rotateWorldViewX(double angle) {
        angle = -angle * Math.PI / 180.0;
        Matrix4D rotation = new Matrix4D(1.0);
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        rotation.setYY(cos);
        rotation.setYZ(-sin);
        rotation.setZY(sin);
        rotation.setZZ(cos);
        Vector4D oldDirection = this.viewDirection;
        this.viewDirection = rotation.multiply(this.viewDirection);
        this.manager.notifyViewRotation(false, oldDirection, this.viewNormal, this.viewDirection, this.viewNormal);
    }

    @Override
    public void rotateWorldViewY(double angle) {
        angle = -angle * Math.PI / 180.0;
        Matrix4D rotation = new Matrix4D(1.0);
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        rotation.setXX(cos);
        rotation.setXZ(sin);
        rotation.setZX(-sin);
        rotation.setZZ(cos);
        Vector4D oldDirection = this.viewDirection;
        this.viewDirection = rotation.multiply(this.viewDirection);
        this.manager.notifyViewRotation(false, oldDirection, this.viewNormal, this.viewDirection, this.viewNormal);
    }

    @Override
    public void rotateWorldViewZ(double angle) {
        angle = -angle * Math.PI / 180.0;
        Matrix4D rotation = new Matrix4D(1.0);
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        rotation.setXX(cos);
        rotation.setXY(-sin);
        rotation.setYX(sin);
        rotation.setYY(cos);
        Vector4D oldDirection = this.viewDirection;
        this.viewDirection = rotation.multiply(this.viewDirection);
        this.manager.notifyViewRotation(false, oldDirection, this.viewNormal, this.viewDirection, this.viewNormal);
    }

    @Override
    public void translateLocalView(double x, double y) {
        Vector4D axis = this.viewDirection.cross(this.viewNormal);
        Vector4D oldLocation = this.viewLocation;
        this.viewLocation = Tools.translate(this.viewLocation, this.viewNormal, y);
        this.viewLocation = Tools.translate(this.viewLocation, axis, x);
        this.manager.notifyViewTranslation(true, oldLocation, this.viewLocation);
    }

    @Override
    public void zoomLocalView(double zoom) {
        Vector4D oldLocation = this.viewLocation;
        this.viewLocation = Tools.translate(this.viewLocation, this.viewDirection, -zoom);
        this.manager.notifyViewTranslation(true, oldLocation, this.viewLocation);
    }

    @Override
    public void flipView() {
        this.viewDirection = this.viewDirection.mul(-1.0);
    }

    @Override
    public Vector4D getViewDirection() {
        return this.viewDirection;
    }

    @Override
    public Vector4D getViewLocation() {
        return this.viewLocation;
    }

    @Override
    public void translateWorldView(double x, double y) {
        Vector4D translation = new Vector4D(x, y, 0.0, 0.0);
        Vector4D oldLocation = new Vector4D(this.viewLocation);
        this.viewLocation.add(translation);
        this.manager.notifyViewTranslation(false, oldLocation, this.viewLocation);
    }

    @Override
    public void zoomWorldView(double z) {
        Vector4D oldLocation = new Vector4D(this.viewLocation);
        Vector4D translation = new Vector4D(0.0, 0.0, z, 0.0);
        this.viewLocation.add(translation);
        this.manager.notifyViewTranslation(false, oldLocation, this.viewLocation);
    }

    @Override
    public double getZoom() {
        return 1.0;
    }

    public void setViewDirection(Vector4D viewDirection) {
        this.viewDirection = viewDirection;
    }

    public void setViewLocation(Vector4D viewLocation) {
        this.viewLocation = viewLocation;
    }

    public void setViewNormal(Vector4D viewNormal) {
        this.viewNormal = viewNormal;
    }

    @Override
    public void setViewDirection(double x, double y, double z) {
        this.viewDirection = new Vector4D(x, y, z, 0.0);
        this.manager.notifyViewChanged();
    }

    @Override
    public void setViewLocation(double x, double y, double z) {
        this.viewLocation = new Vector4D(x, y, z, 1.0);
        this.manager.notifyViewChanged();
    }

    @Override
    public void setViewNormal(double x, double y, double z) {
        this.viewNormal = new Vector4D(x, y, z, 0.0);
        this.manager.notifyViewChanged();
    }

    @Override
    public void setZoom(double zoom) {
    }
}

