package rnadesign.rnamodel;

import generaltools.*;
import tools3d.*;
import tools3d.objects3d.*;
import sequence.*;
import rnasecondary.*;

public class Protein3DTools {

    public static final double RAD2DEG = 180.0 / Math.PI;

    public static final double DEG2RAD = Math.PI / 180.0;

    // TODO

    public static final double HELIX_RISE = 3.4; // rize in z-coordinate per base-pair in helix

    // public static final double HELIX_DELTA_ANGLE = 36.0 * DEG2RAD; // rize in z-coordinate per base-pair in helix
    
    // public static final double HELIX_CENTER_DIST = 5.0; // distance of center of base pair from helix axis

    // public static final double HELIX_BASE_DIST = 5.0; // distance of centers of bases of base pair

    public static final double RESIDUE_DIST = 3.5;

    public static final double WATSON_CRICK_DIST_MIN = 3.0;

    public static final double WATSON_CRICK_DIST = 4.0;

    public static final double WATSON_CRICK_DIST_MAX = 5.0;

    public static final ConstraintDouble RNA_WC_CONSTRAINT = new SimpleConstraintDouble(WATSON_CRICK_DIST_MIN,
										     WATSON_CRICK_DIST_MAX);

    /** minimum and maximum distances of bases in RNA chain TODO */
    public static final ConstraintDouble RNA_CHAIN_CONSTRAINT = new SimpleConstraintDouble(WATSON_CRICK_DIST_MIN,
										     WATSON_CRICK_DIST_MAX);


    /** searches all known stems TODO: no recursive search !*/
    public static Object3DSet collectProteinStrands(Object3D root) {
	Object3DSet stemSet = new SimpleObject3DSet();
	for (int i = 0; i < root.size(); ++i) {
	    Object3D child = root.getChild(i);
	    if (child instanceof ProteinStrand) {
		stemSet.add(child);
	    }
	}
	return stemSet;
    }

    /** generates RNA strand with one Nucleotide3D object per residue and no atoms */
    public static Object3DLinkSetBundle generateSimpleProteinStrand(String name,
	    String seqString, Vector3D pos , Vector3D dir) throws UnknownSymbolException {
	assert false; // not supported anymore
	return null;
// 	ProteinStrand strand = new SimpleProteinStrand(seqString, name);
// 	// log.fine("generated initial strand " +strand.size() + " " + seqString);
// 	// RnaStrand helpStrand = new SimpleRnaStrand(seqString, name);
// 	strand.setPosition(pos);
// 	Sequence seq = strand.getSequence();
// 	for (int i = 0; i < seq.size(); ++i) {
// 	    LetterSymbol symbol = seq.getResidue(i).getSymbol();
// 	    // TODO still wrong constants used
// 	    AminoAcid3D residue = new AminoAcid3D(symbol, i, pos.plus(dir.mul(RESIDUE_DIST*i)));
// 	    double r = RnaPhysicalProperties.RNA_AVERAGE_BASE_RADIUS;
// 	    residue.setDimensions(new Vector3D(r, r, r));
// 	    Character character = new Character(symbol.getCharacter());
// 	    String resName = "" + character.toString() + (i+1);
// 	    residue.setName(resName);
// 	    residue.setBoundingRadius(r);
// 	    strand.insertChild(residue);
// 	}
// 	LinkSet links = new SimpleLinkSet();
// 	for (int i = 1; i < strand.size(); ++i) {
// 	    links.add(new SimpleConstraintLink(strand.getChild(i-1),strand.getChild(i), RNA_CHAIN_CONSTRAINT)); 
// 	}
// 	return new SimpleObject3DLinkSetBundle(strand, links);
    }

    /** translates one letter code to three letter code */
    public static String oneLetterToThreeLetter(char c) {
	switch (c) {
	case 'A': return "ALA";
	case 'C': return "CYS";
	case 'D': return "ASP";
	case 'E': return "GLU";
	case 'F': return "PHE";
	case 'G': return "GLY";
	case 'H': return "HIS";
	case 'I': return "ILE";
	case 'K': return "LYS";
	case 'L': return "LEU";
	case 'M': return "MET";
	case 'N': return "ASN";
	case 'P': return "PRO";
	case 'Q': return "GLN";
	case 'R': return "ARG";
	case 'S': return "SER";
	case 'T': return "THR";
	case 'V': return "VAL";
	case 'W': return "TRP";
	case 'Y': return "TYR";
	}
	return "UNK"; // unknown amino acid
    }

}
