package rnasecondary;

import java.util.*;

import java.util.logging.Logger;
import sequence.*;

// import static rnadesign.rnamodel.PackageConstants.*;
import static rnasecondary.PackageConstants.*;

/** Output of secondary structure as single-strand "CT" format (as generated by mfold and other programs) */
public class SecondaryStructureCTFormatWriter implements SecondaryStructureWriter {

    public static final char NO_BASE_PAIR_CHAR = '.';

    public static Logger log = Logger.getLogger("NanoTiler_debug");

    private boolean writeSequenceMode = true;

    private boolean purgeMultipleInteractions = true; // if true, remove interactions that cannot be drawn as paranthesis

    private int stride = 0;

    private String strideString = "";

    public SecondaryStructureCTFormatWriter() { }

    /** Generates one concatenated sequence */
    public static String generateConcatenatedSequenceString(SecondaryStructure structure) {
        assert structure != null;
	StringBuffer buf = new StringBuffer();
 	for (int i = 0; i < structure.getSequenceCount(); ++i) {
	    Sequence seq = structure.getSequence(i);
	    buf.append(seq.sequenceString());
	}
	return buf.toString();
    }

    /** generates array of integers as if all sequences were concatenated to one sequence */
    private  int[] convertSingleSeqInteractions(SecondaryStructure structure) {
        assert structure != null;
	String concatSeq = generateConcatenatedSequenceString(structure);
	int[] interactions = new int[concatSeq.length()];
	for (int i = 0; i < interactions.length; ++i) {
	    interactions[i] = -1; // no base pair initially
	}
	int [] starts = structure.getStarts(); // new int[structure.getSequenceCount()];
	// starts[0] = 0;
	// for (int i = 1; i < structure.getSequenceCount(); ++i) {
	// starts[i] = starts[i-1] + structure.getSequence(i-1).size();
	// }
	for (int i = 0; i < structure.getSequenceCount(); ++i) {
	    for (int j = i; j < structure.getSequenceCount(); ++j) {
		int[][] mtx = structure.toInteractionMatrix(i, j); // generate interaction matrix
		for (int m = 0; m < mtx.length; ++m) {
		    for (int n = 0; n < mtx[m].length; ++n) {
			if (mtx[m][n] != RnaInteractionType.NO_INTERACTION) {
			    interactions[starts[i] + m] = starts[j] + n;
			    interactions[starts[j] + n] = starts[i] + m;
			    assert(starts[i] + m < interactions.length);
			    assert(starts[j] + n < interactions.length);
			}
		    }
		}
	    }
	}
	return interactions;
    }

    /** writes n copies of char c to StringBuffer */
    private void appendChars(StringBuffer buf, char c, int n) {
	assert(n >= 0);
	for (int i = 0; i < n; ++i) {
	    buf.append(c);
	}
    }

    /** generates array of integers as if all sequences were concatenated to one sequence */
    public String writeString(String sequence, SecondaryStructure structure) {
        assert structure != null;
	StringBuffer buf = new StringBuffer();
	int numEntries = sequence.length();
	int[] connections = convertSingleSeqInteractions(structure);
	int[] starts = structure.getStarts();
	buf.append("" + sequence.length() + " "); // + NEWLINE); // " ENERGY = 0.0 DROTRE4        75 bp ss-tRNA" << endl;
	buf.append("" + starts.length);
	for (int i = 0; i < starts.length; ++i) {
	    buf.append(" " + (starts[i] + 1));
	}
	buf.append(NEWLINE);
	for (int i = 0; i < numEntries; ++i) {
	    String s1 = "" + (i + 1);
	    int len1 = s1.length();
	    int sp1l = 5-len1;
	    assert(sp1l >= 0);
	    appendChars(buf, ' ', sp1l); 
	    char resChar = sequence.charAt(i);
	    if (resChar == '.') {
		resChar = '-';
	    }
	    buf.append(s1 + " " + resChar);
	    String s2 = "" + (i);
	    int len2 = s2.length();
	    int sp2l = 6-len2;
	    assert(sp2l >= 0);
	    appendChars(buf, ' ', sp2l); 
	    buf.append(s2);
	    String s3 = "" + (i+2);
	    int len3 = s3.length();
	    int sp3l = 6-len3;
	    assert(sp3l >= 0);
	    appendChars(buf, ' ', sp3l); 
	    buf.append(s3);
	    String s4 = "" + (connections[i]+1);
	    int len4 = s4.length();
	    int sp4l = 6-len4;
	    assert(sp4l >= 0);
	    appendChars(buf, ' ', sp4l); 
	    buf.append(s4);
	    int sp1lb = 6-len1;
	    assert(sp1lb >= 0);
	    appendChars(buf, ' ', sp1lb); 
	    buf.append(s1);
	    buf.append(NEWLINE);
	}
	return buf.toString();
    }

    /** generates array of integers as if all sequences were concatenated to one sequence */
    public String writeString(SecondaryStructure structure) {
        assert structure != null;
	String sequence = generateConcatenatedSequenceString(structure);
	return writeString(sequence, structure);
    }

}
