package tools3d.objects3d;

public class Object3DXmlWriterTools implements Object3DWriterTools {

    /** returns format id */
    public int getFormatId() { return XML_FORMAT; }

    /** writes integer array */
    public String writeIntArray(int[] ary) {
	StringBuffer buf = new StringBuffer();
	buf.append("<ARY size=\"" + ary.length + "\" > " + ary.length);
	for (int i = 0; i < ary.length; ++i) {
	    buf.append(" " + ary[i]);
	}
	buf.append(" </ARY>");
	return buf.toString();
    }

    /** writes boolean to string */
    public String writeBoolean(String name, boolean b) {
	String flag = "true";
	if (!b) {
	    flag = "false";
	}
	return encloseBody(name, flag);
    }

    /** returns header string. Central for switching formats! */
    public String getHeader(String className) { return "<" + className + "> "; }

    /** returns footer : closing bracket in this format */
    public String getFooter(String className) { return " </" + className + " "; }

    /** encloses body text by item specified <className> bodyText </className> in XML for example */
    public String encloseBody(String className, String bodyText) {
	return getHeader(className) + bodyText + getFooter(className);
    }

}
