/*
 * Decompiled with CFR 0.152.
 */
package de.bezier.guido;

import de.bezier.guido.Basic2DElement;
import de.bezier.guido.Interactive;

public abstract class AbstractActiveElement
extends Basic2DElement {
    protected float clickedMouseX;
    protected float clickedMouseY;
    protected float clickedPositionX;
    protected float clickedPositionY;
    protected float draggedDistX;
    protected float draggedDistY;
    public boolean pressed;
    public boolean dragged;
    public boolean hover;
    public boolean activated = true;
    protected boolean debug = false;
    long lastPressed = 0L;

    public AbstractActiveElement() {
        Interactive.get().addElement(this);
    }

    public AbstractActiveElement(float f, float f2, float f3, float f4) {
        super(f, f2, f3, f4);
        Interactive.get().addElement(this);
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public void setActive(boolean bl) {
        this.activated = bl;
    }

    public boolean isActive() {
        return this.activated;
    }

    public void mouseEntered() {
    }

    public void mouseEntered(float f, float f2) {
    }

    public void mouseMoved() {
    }

    public void mouseMoved(float f, float f2) {
    }

    public void mouseExited() {
    }

    public void mouseExited(float f, float f2) {
    }

    public void mousePressedPre(float f, float f2) {
        if (!this.isActive()) {
            return;
        }
        this.pressed = this.isInside(f, f2);
        if (this.pressed) {
            this.clickedPositionX = this.x;
            this.clickedPositionY = this.y;
            this.clickedMouseX = f;
            this.clickedMouseY = f2;
            long l = System.currentTimeMillis();
            long l2 = this.lastPressed;
            this.lastPressed = l;
            if (l - l2 < 200L) {
                this.mouseDoubleClicked();
                this.mouseDoubleClicked(f, f2);
            } else {
                this.mousePressed();
                this.mousePressed(f, f2);
            }
        }
    }

    public abstract void mousePressed();

    public abstract void mousePressed(float var1, float var2);

    public abstract void mouseDoubleClicked();

    public abstract void mouseDoubleClicked(float var1, float var2);

    public void mouseDraggedPre(float f, float f2) {
        if (!this.isActive()) {
            return;
        }
        this.dragged = this.pressed;
        if (this.dragged) {
            this.draggedDistX = this.clickedMouseX - f;
            this.draggedDistY = this.clickedMouseY - f2;
            this.mouseDragged(f, f2);
            this.mouseDragged(f, f2, this.clickedPositionX - this.draggedDistX, this.clickedPositionY - this.draggedDistY);
        }
    }

    public abstract void mouseDragged(float var1, float var2);

    public abstract void mouseDragged(float var1, float var2, float var3, float var4);

    public void mouseReleasedPre(float f, float f2) {
        if (!this.isActive()) {
            return;
        }
        if (this.dragged) {
            this.draggedDistX = this.clickedMouseX - f;
            this.draggedDistY = this.clickedMouseY - f2;
        }
        if (this.pressed) {
            this.mouseReleased();
        }
        this.mouseReleased(f, f2);
    }

    public abstract void mouseReleased();

    public abstract void mouseReleased(float var1, float var2);

    public void mouseReleasedPost(float f, float f2) {
        this.pressed = false;
        this.dragged = false;
    }

    public void mouseScrolled(float f) {
    }

    public void draw() {
    }
}

