/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr;

import com.oracle.jrockit.jfr.management.NoSuchRecordingException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import oracle.jrockit.jfr.DCmd;
import oracle.jrockit.jfr.DCmdException;
import oracle.jrockit.jfr.JFR;
import oracle.jrockit.jfr.Recording;
import oracle.jrockit.jfr.VMJFR;
import oracle.jrockit.jfr.settings.EventDefaultSet;
import oracle.jrockit.jfr.settings.PresetFile;

final class DCmdStart
extends DCmd {
    DCmdStart(VMJFR vMJFR) {
        super(vMJFR);
    }

    public void execute(String string, String[] stringArray, boolean bl, long l, long l2, String string2, boolean bl2, long l3, long l4, boolean bl3) throws DCmdException {
        Object object;
        if (bl) {
            this.startDefault(bl3, string, stringArray, l, l2, string2, bl2, l3, l4);
            return;
        }
        if (string2 != null && l2 == 0L && !bl3) {
            throw new DCmdException("Filename can only be set for a recording with a duration, or if dumponexit=true", new Object[0]);
        }
        String string3 = string;
        if (string2 != null && string3 == null) {
            object = new File(string2);
            string3 = ((File)object).getName();
        }
        object = null;
        try {
            Object object2;
            String string42;
            object = this.createRecording(string3);
            ((Recording)object).setDumpOnExit(bl3);
            for (String string42 : this.settingsToList(stringArray)) {
                object2 = this.findPreset(string42);
                ((Recording)object).getEventSettings().addEventDefaultSet((EventDefaultSet)object2);
            }
            if (l2 != 0L && (l2 = TimeUnit.MILLISECONDS.convert(l2, TimeUnit.NANOSECONDS)) < 1000L) {
                throw new DCmdException("Could not start recording, duration must be at least 1 second.", new Object[0]);
            }
            if (l != 0L && (l = TimeUnit.MILLISECONDS.convert(l, TimeUnit.NANOSECONDS)) < 1000L) {
                throw new DCmdException("Could not start recording, delay must be at least 1 second.", new Object[0]);
            }
            if (l3 != 0L) {
                l3 = TimeUnit.MILLISECONDS.convert(l3, TimeUnit.NANOSECONDS);
            }
            ((Recording)object).setDuration(l2, TimeUnit.MILLISECONDS);
            try {
                ((Recording)object).setDestination(string2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                string42 = "Could not start recording, not able to write to file \"%s\"";
                throw new DCmdException(fileNotFoundException, string42, string2);
            }
            catch (IOException iOException) {
                string42 = "Could not start recording. %s";
                throw new DCmdException(iOException, string42, this.formatException(iOException));
            }
            ((Recording)object).setDestinationCompressed(bl2);
            ((Recording)object).setMaxAge(l3, TimeUnit.MILLISECONDS);
            ((Recording)object).setMaxSize(l4);
            if (l != 0L) {
                long l5 = TimeUnit.NANOSECONDS.convert(l, TimeUnit.MILLISECONDS);
                ((Recording)object).setStartTime(new Date(System.currentTimeMillis() + l));
                this.print("Recording %d scheduled to start in ", ((Recording)object).getId());
                this.printTimespan(l5, " ");
                this.print(".");
            } else {
                ((Recording)object).start();
                this.print("Started recording %d.", ((Recording)object).getId());
            }
            if (((Recording)object).isToDisk() && l2 == 0L && l3 == 0L && l4 == 0L) {
                this.print(" No limit (duration/maxsize/maxage) in use.");
            }
            if (string2 != null && l2 != 0L) {
                this.println(" The result will be written to:", new Object[0]);
                this.println();
                this.printPath(string2);
            } else {
                this.println();
                this.println();
                String string5 = l2 == 0L ? "dump" : "stop";
                string42 = string2 == null ? "filename=FILEPATH " : "";
                object2 = "recording=" + ((Recording)object).getId();
                if (string != null) {
                    object2 = "name=" + DCmdStart.quoteIfNeeded(string);
                }
                this.println("Use JFR.%s %s %sto copy recording data to file.", string5, object2, string42);
            }
        }
        catch (Exception exception) {
            if (object != null) {
                this.jfrMBean.close((Recording)object);
            }
            throw exception;
        }
    }

    List<String> settingsToList(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (stringArray != null) {
            arrayList.addAll(Arrays.asList(stringArray));
        }
        if (arrayList.isEmpty()) {
            arrayList.add("default");
        }
        return arrayList;
    }

    private Recording createRecording(String string) throws DCmdException {
        try {
            return this.jfrMBean.getRecording(this.jfrMBean.createRecording(string));
        }
        catch (NoSuchRecordingException noSuchRecordingException) {
            throw new DCmdException("Unexpected error when creating recording with name \"%s\"", string);
        }
    }

    private void startDefault(boolean bl, String string, String[] stringArray, long l, long l2, String string2, boolean bl2, long l3, long l4) throws DCmdException {
        if (string != null) {
            throw new DCmdException("It's not possible to set custom name for the defaultrecording. It's always \"HotSpot default\"", new Object[0]);
        }
        if (string2 != null || l != 0L || l3 != 0L || l4 != 0L || l2 != 0L || bl2) {
            throw new DCmdException("The only option that can be combined with defaultrecording is settings.", new Object[0]);
        }
        List<String> list = this.settingsToList(stringArray);
        JFR.checkControl();
        this.jfr.enableDefaultRecording(list, bl);
        this.print("Started recording \"%s\"", "HotSpot default");
        this.println();
        this.print("Use JFR.dump recording=%d filename=FILEPATH to copy recording data to file.", JFR.DEFAULT_RECORDING_ID);
    }

    private EventDefaultSet findPreset(String string) throws DCmdException {
        String string2 = "Could not start recording, not able to %s jfc-file in %s for setting=%s.%s";
        try {
            return PresetFile.createFromName(string).getSettings();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new DCmdException(fileNotFoundException, string2, "find", "JRE_HOME/lib/jfr", string, "");
        }
        catch (IOException iOException) {
            throw new DCmdException(iOException, string2, "read", "JRE_HOME/lib/jfr", string, " " + this.formatException(iOException));
        }
        catch (URISyntaxException | ParseException exception) {
            throw new DCmdException(exception, string2, "parse", "JRE_HOME/lib/jfr", string, " " + this.formatException(exception));
        }
        catch (SecurityException securityException) {
            throw new DCmdException(securityException, string2, "access", "JRE_HOME/lib/jfr", string, " " + this.formatException(securityException));
        }
        catch (Exception exception) {
            throw new DCmdException(exception, "Could not start recording. Unexpected error occured when loading setting %s from %s. %s", string, "JRE_HOME/lib/jfr", this.formatException(exception));
        }
    }
}

