/*
 * Decompiled with CFR 0.152.
 */
package processing.javafx;

import java.util.HashMap;
import java.util.Map;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javafx.util.Duration;
import processing.core.PApplet;
import processing.core.PImage;
import processing.core.PSurface;
import processing.javafx.PGraphicsFX2D;

public class PSurfaceFX
implements PSurface {
    PApplet sketch;
    PGraphicsFX2D fx;
    Stage stage;
    Canvas canvas;
    final Animation animation;
    static Map<EventType<? extends MouseEvent>, Integer> mouseMap = new HashMap<EventType<? extends MouseEvent>, Integer>();

    static {
        mouseMap.put((EventType<? extends MouseEvent>)MouseEvent.MOUSE_PRESSED, 1);
        mouseMap.put((EventType<? extends MouseEvent>)MouseEvent.MOUSE_RELEASED, 2);
        mouseMap.put((EventType<? extends MouseEvent>)MouseEvent.MOUSE_CLICKED, 3);
        mouseMap.put((EventType<? extends MouseEvent>)MouseEvent.MOUSE_DRAGGED, 4);
        mouseMap.put((EventType<? extends MouseEvent>)MouseEvent.MOUSE_MOVED, 5);
        mouseMap.put((EventType<? extends MouseEvent>)MouseEvent.MOUSE_ENTERED, 6);
        mouseMap.put((EventType<? extends MouseEvent>)MouseEvent.MOUSE_EXITED, 7);
    }

    public PSurfaceFX(PGraphicsFX2D graphics) {
        this.fx = graphics;
        this.canvas = new ResizableCanvas();
        KeyFrame keyFrame = new KeyFrame(Duration.millis((double)1000.0), (EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                PSurfaceFX.this.sketch.handleDraw();
                if (PSurfaceFX.this.sketch.exitCalled()) {
                    Platform.exit();
                }
            }
        }, new KeyValue[0]);
        this.animation = new Timeline(new KeyFrame[]{keyFrame});
        this.animation.setCycleCount(-1);
        this.animation.setRate(-60.0);
    }

    @Override
    public Object getNative() {
        return this.canvas;
    }

    @Override
    public void initOffscreen(PApplet sketch) {
    }

    @Override
    public void initFrame(PApplet sketch) {
        this.sketch = sketch;
        PApplicationFX.surface = this;
        new Thread(new Runnable(){

            @Override
            public void run() {
                Application.launch(PApplicationFX.class, (String[])new String[0]);
            }
        }).start();
        while (this.stage == null) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public void setTitle(String title) {
        this.stage.setTitle(title);
    }

    @Override
    public void setVisible(boolean visible) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                PSurfaceFX.this.stage.show();
                PSurfaceFX.this.canvas.requestFocus();
            }
        });
    }

    @Override
    public void setResizable(boolean resizable) {
        this.stage.setResizable(resizable);
    }

    @Override
    public void setIcon(PImage icon) {
    }

    @Override
    public void placeWindow(int[] location, int[] editorLocation) {
        if (location != null) {
            this.stage.setX((double)location[0]);
            this.stage.setY((double)location[1]);
        } else if (editorLocation != null) {
            int locationX = editorLocation[0] - 20;
            int locationY = editorLocation[1];
            if ((double)locationX - this.stage.getWidth() > 10.0) {
                this.stage.setX((double)locationX - this.stage.getWidth());
                this.stage.setY((double)locationY);
            } else {
                locationX = editorLocation[0] + 66;
                locationY = editorLocation[1] + 66;
                if ((double)locationX + this.stage.getWidth() > (double)(this.sketch.displayWidth - 33) || (double)locationY + this.stage.getHeight() > (double)(this.sketch.displayHeight - 33)) {
                    locationX = (int)(((double)this.sketch.displayWidth - this.stage.getWidth()) / 2.0);
                    locationY = (int)(((double)this.sketch.displayHeight - this.stage.getHeight()) / 2.0);
                }
                this.stage.setX((double)locationX);
                this.stage.setY((double)locationY);
            }
        }
        if (this.stage.getY() < 0.0) {
            this.stage.setY(30.0);
        }
        if (this.sketch.getGraphics().displayable()) {
            this.setVisible(true);
        }
    }

    @Override
    public void placePresent(int stopColor) {
    }

    @Override
    public void setupExternalMessages() {
        this.stage.xProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> value, Number oldX, Number newX) {
                PSurfaceFX.this.sketch.frameMoved(newX.intValue(), PSurfaceFX.this.stage.yProperty().intValue());
            }
        });
        this.stage.yProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> value, Number oldY, Number newY) {
                PSurfaceFX.this.sketch.frameMoved(PSurfaceFX.this.stage.xProperty().intValue(), newY.intValue());
            }
        });
        this.stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent we) {
                PSurfaceFX.this.sketch.exit();
            }
        });
    }

    @Override
    public void setLocation(int x, int y) {
        this.stage.setX((double)x);
        this.stage.setY((double)y);
    }

    @Override
    public void setSize(int width, int height) {
        Scene scene = this.stage.getScene();
        double decorH = this.stage.getWidth() - scene.getWidth();
        double decorV = this.stage.getHeight() - scene.getHeight();
        this.stage.setWidth((double)width + decorH);
        this.stage.setHeight((double)height + decorV);
        this.fx.setSize(width, height);
    }

    public void setSmooth(int level) {
    }

    @Override
    public void setFrameRate(float fps) {
        if (fps > 0.0f) {
            this.animation.setRate((double)(-fps));
        }
    }

    @Override
    public void setCursor(int kind) {
    }

    @Override
    public void setCursor(PImage image, int hotspotX, int hotspotY) {
    }

    @Override
    public void showCursor() {
    }

    @Override
    public void hideCursor() {
    }

    @Override
    public void startThread() {
        this.animation.play();
    }

    @Override
    public void pauseThread() {
        this.animation.pause();
    }

    @Override
    public void resumeThread() {
        this.animation.play();
    }

    @Override
    public boolean stopThread() {
        this.animation.stop();
        return true;
    }

    @Override
    public boolean isStopped() {
        return this.animation.getStatus() == Animation.Status.STOPPED;
    }

    protected void fxMouseEvent(MouseEvent fxEvent) {
        int count = fxEvent.getClickCount();
        int action = mouseMap.get(fxEvent.getEventType());
        int modifiers = 0;
        if (fxEvent.isShiftDown()) {
            modifiers |= 1;
        }
        if (fxEvent.isControlDown()) {
            modifiers |= 2;
        }
        if (fxEvent.isMetaDown()) {
            modifiers |= 4;
        }
        if (fxEvent.isAltDown()) {
            modifiers |= 8;
        }
        int button = 0;
        if (fxEvent.isPrimaryButtonDown()) {
            button = 37;
        } else if (fxEvent.isSecondaryButtonDown()) {
            button = 39;
        } else if (fxEvent.isMiddleButtonDown()) {
            button = 3;
        }
        if (PApplet.platform == 2 && fxEvent.isControlDown() && button == 37) {
            button = 39;
        }
        long when = System.currentTimeMillis();
        int x = (int)fxEvent.getX();
        int y = (int)fxEvent.getY();
        this.sketch.postEvent(new processing.event.MouseEvent(fxEvent, when, action, modifiers, x, y, button, count));
    }

    protected void fxScrollEvent(ScrollEvent event) {
    }

    protected void fxKeyEvent(KeyEvent fxEvent) {
        int action = 0;
        EventType et = fxEvent.getEventType();
        if (et == KeyEvent.KEY_PRESSED) {
            action = 1;
        } else if (et == KeyEvent.KEY_RELEASED) {
            action = 2;
        } else if (et == KeyEvent.KEY_TYPED) {
            action = 3;
        }
        int modifiers = 0;
        if (fxEvent.isShiftDown()) {
            modifiers |= 1;
        }
        if (fxEvent.isControlDown()) {
            modifiers |= 2;
        }
        if (fxEvent.isMetaDown()) {
            modifiers |= 4;
        }
        if (fxEvent.isAltDown()) {
            modifiers |= 8;
        }
        long when = System.currentTimeMillis();
        char keyChar = this.getKeyChar(fxEvent);
        int keyCode = this.getKeyCode(fxEvent);
        this.sketch.postEvent(new processing.event.KeyEvent(fxEvent, when, action, modifiers, keyChar, keyCode));
    }

    private int getKeyCode(KeyEvent fxEvent) {
        if (fxEvent.getEventType() == KeyEvent.KEY_TYPED) {
            return 0;
        }
        KeyCode kc = fxEvent.getCode();
        switch (kc) {
            case ALT_GRAPH: {
                return 18;
            }
        }
        return kc.impl_getCode();
    }

    private char getKeyChar(KeyEvent fxEvent) {
        if (fxEvent.getEventType() == KeyEvent.KEY_TYPED) {
            return fxEvent.getCharacter().charAt(0);
        }
        KeyCode kc = fxEvent.getCode();
        if (kc.isKeypadKey()) {
            return (char)(kc.impl_getChar().charAt(0) - 49 + 1);
        }
        switch (kc) {
            case SHIFT: 
            case CONTROL: 
            case ALT: 
            case PAUSE: 
            case CAPS: 
            case PAGE_UP: 
            case PAGE_DOWN: 
            case END: 
            case HOME: 
            case LEFT: 
            case UP: 
            case RIGHT: 
            case DOWN: 
            case NUM_LOCK: 
            case SCROLL_LOCK: 
            case F1: 
            case F2: 
            case F3: 
            case F4: 
            case F5: 
            case F6: 
            case F7: 
            case F8: 
            case F9: 
            case F10: 
            case F11: 
            case F12: 
            case PRINTSCREEN: 
            case INSERT: 
            case META: 
            case KP_UP: 
            case KP_DOWN: 
            case KP_LEFT: 
            case KP_RIGHT: 
            case WINDOWS: 
            case CONTEXT_MENU: 
            case ALT_GRAPH: {
                return '\uffff';
            }
            case ENTER: {
                return '\n';
            }
        }
        return kc.impl_getChar().charAt(0);
    }

    public static class PApplicationFX
    extends Application {
        public static PSurfaceFX surface;

        public void start(Stage stage) {
            Canvas canvas = PApplicationFX.surface.canvas;
            PApplicationFX.surface.fx.context = canvas.getGraphicsContext2D();
            StackPane stackPane = new StackPane();
            stackPane.getChildren().add((Object)canvas);
            canvas.widthProperty().bind((ObservableValue)stackPane.widthProperty());
            canvas.heightProperty().bind((ObservableValue)stackPane.heightProperty());
            PApplet sketch = PApplicationFX.surface.sketch;
            int width = sketch.sketchWidth();
            int height = sketch.sketchHeight();
            stage.setScene(new Scene((Parent)stackPane, (double)width, (double)height));
            PApplicationFX.surface.stage = stage;
        }
    }

    class ResizableCanvas
    extends Canvas {
        public ResizableCanvas() {
            this.widthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                public void changed(ObservableValue<? extends Number> value, Number oldWidth, Number newWidth) {
                    ((ResizableCanvas)ResizableCanvas.this).PSurfaceFX.this.sketch.setSize(newWidth.intValue(), ((ResizableCanvas)ResizableCanvas.this).PSurfaceFX.this.sketch.height);
                    ((ResizableCanvas)ResizableCanvas.this).PSurfaceFX.this.fx.setSize(((ResizableCanvas)ResizableCanvas.this).PSurfaceFX.this.sketch.width, ((ResizableCanvas)ResizableCanvas.this).PSurfaceFX.this.sketch.height);
                }
            });
            this.heightProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                public void changed(ObservableValue<? extends Number> value, Number oldHeight, Number newHeight) {
                    ((ResizableCanvas)ResizableCanvas.this).PSurfaceFX.this.sketch.setSize(((ResizableCanvas)ResizableCanvas.this).PSurfaceFX.this.sketch.width, newHeight.intValue());
                    ((ResizableCanvas)ResizableCanvas.this).PSurfaceFX.this.fx.setSize(((ResizableCanvas)ResizableCanvas.this).PSurfaceFX.this.sketch.width, ((ResizableCanvas)ResizableCanvas.this).PSurfaceFX.this.sketch.height);
                }
            });
            EventHandler<MouseEvent> mouseHandler = new EventHandler<MouseEvent>(){

                public void handle(MouseEvent e) {
                    PSurfaceFX.this.fxMouseEvent(e);
                }
            };
            this.setOnMousePressed((EventHandler)mouseHandler);
            this.setOnMouseReleased((EventHandler)mouseHandler);
            this.setOnMouseClicked((EventHandler)mouseHandler);
            this.setOnMouseEntered((EventHandler)mouseHandler);
            this.setOnMouseExited((EventHandler)mouseHandler);
            this.setOnMouseDragged((EventHandler)mouseHandler);
            this.setOnMouseMoved((EventHandler)mouseHandler);
            this.setOnScroll((EventHandler)new EventHandler<ScrollEvent>(){

                public void handle(ScrollEvent e) {
                    PSurfaceFX.this.fxScrollEvent(e);
                }
            });
            EventHandler<KeyEvent> keyHandler = new EventHandler<KeyEvent>(){

                public void handle(KeyEvent e) {
                    PSurfaceFX.this.fxKeyEvent(e);
                }
            };
            this.setOnKeyPressed((EventHandler)keyHandler);
            this.setOnKeyReleased((EventHandler)keyHandler);
            this.setOnKeyTyped((EventHandler)keyHandler);
            this.setFocusTraversable(false);
            this.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> value, Boolean oldValue, Boolean newValue) {
                    if (newValue.booleanValue()) {
                        ((ResizableCanvas)ResizableCanvas.this).PSurfaceFX.this.sketch.focused = true;
                        ((ResizableCanvas)ResizableCanvas.this).PSurfaceFX.this.sketch.focusGained();
                    } else {
                        ((ResizableCanvas)ResizableCanvas.this).PSurfaceFX.this.sketch.focused = false;
                        ((ResizableCanvas)ResizableCanvas.this).PSurfaceFX.this.sketch.focusLost();
                    }
                }
            });
        }

        public Stage getStage() {
            return PSurfaceFX.this.stage;
        }

        public boolean isResizable() {
            return true;
        }

        public double prefWidth(double height) {
            return this.getWidth();
        }

        public double prefHeight(double width) {
            return this.getHeight();
        }
    }
}

