/*
 * Decompiled with CFR 0.152.
 */
package processing.opengl;

import com.jogamp.common.util.IOUtil;
import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.nativewindow.MutableGraphicsConfiguration;
import com.jogamp.nativewindow.NativeSurface;
import com.jogamp.newt.Display;
import com.jogamp.newt.MonitorDevice;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.Window;
import com.jogamp.newt.awt.NewtCanvasAWT;
import com.jogamp.newt.event.KeyAdapter;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.MouseAdapter;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.event.WindowUpdateEvent;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLAnimatorControl;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.util.FPSAnimator;
import java.awt.Component;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PSurface;
import processing.opengl.PGL;
import processing.opengl.PGraphicsOpenGL;
import processing.opengl.PJOGL;

public class PSurfaceJOGL
implements PSurface {
    public static GLProfile profile;
    PJOGL pgl;
    GLWindow window;
    FPSAnimator animator;
    Rectangle screenRect;
    PApplet sketch;
    PGraphics graphics;
    int sketchX;
    int sketchY;
    int sketchWidth;
    int sketchHeight;
    Display display;
    Screen screen;
    List<MonitorDevice> monitors;
    MonitorDevice displayDevice;
    Throwable drawException;
    Object waitObject = new Object();
    NewtCanvasAWT canvas;
    boolean placedWindow = false;
    boolean requestedStart = false;
    float[] currentPixelScale = new float[]{0.0f, 0.0f};
    boolean presentMode = false;
    float offsetX;
    float offsetY;

    public PSurfaceJOGL(PGraphics graphics) {
        this.graphics = graphics;
        this.pgl = (PJOGL)((PGraphicsOpenGL)graphics).pgl;
    }

    @Override
    public void initOffscreen(PApplet sketch) {
        this.sketch = sketch;
        this.sketchWidth = sketch.sketchWidth();
        this.sketchHeight = sketch.sketchHeight();
        if (this.window != null) {
            this.canvas = new NewtCanvasAWT((Window)this.window);
            this.canvas.setBounds(0, 0, this.window.getWidth(), this.window.getHeight());
            this.canvas.setFocusable(true);
        }
    }

    @Override
    public void initFrame(PApplet sketch) {
        this.sketch = sketch;
        this.initIcons();
        this.initScreen();
        this.initGL();
        this.initWindow();
        this.initListeners();
        this.initAnimator();
    }

    @Override
    public Object getNative() {
        return this.window;
    }

    protected void initScreen() {
        this.display = NewtFactory.createDisplay(null);
        this.display.addReference();
        this.screen = NewtFactory.createScreen((Display)this.display, (int)0);
        this.screen.addReference();
        this.monitors = new ArrayList<MonitorDevice>();
        GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] awtDevices = environment.getScreenDevices();
        List newtDevices = this.screen.getMonitorDevices();
        if (PApplet.platform == 3) {
            GraphicsDevice[] graphicsDeviceArray = awtDevices;
            int n = awtDevices.length;
            int n2 = 0;
            while (n2 < n) {
                GraphicsDevice device = graphicsDeviceArray[n2];
                String did = device.getIDstring();
                String[] parts = did.split("\\.");
                String id1 = "";
                if (1 < parts.length) {
                    id1 = parts[1].trim();
                }
                MonitorDevice monitor = null;
                int id0 = newtDevices.size() > 0 ? ((MonitorDevice)newtDevices.get(0)).getId() : 0;
                int i = 0;
                while (i < newtDevices.size()) {
                    MonitorDevice mon = (MonitorDevice)newtDevices.get(i);
                    String mid = String.valueOf(mon.getId() - id0);
                    if (id1.equals(mid)) {
                        monitor = mon;
                        break;
                    }
                    ++i;
                }
                if (monitor != null) {
                    this.monitors.add(monitor);
                }
                ++n2;
            }
        } else {
            GraphicsDevice[] graphicsDeviceArray = awtDevices;
            int n = awtDevices.length;
            int n3 = 0;
            while (n3 < n) {
                String mid;
                MonitorDevice mon;
                GraphicsDevice device = graphicsDeviceArray[n3];
                String did = device.getIDstring();
                String[] parts = did.split("Display");
                String id1 = "";
                if (1 < parts.length) {
                    id1 = parts[1].trim();
                }
                MonitorDevice monitor = null;
                int i = 0;
                while (i < newtDevices.size()) {
                    mon = (MonitorDevice)newtDevices.get(i);
                    mid = String.valueOf(mon.getId());
                    if (id1.equals(mid)) {
                        monitor = mon;
                        break;
                    }
                    ++i;
                }
                if (monitor == null) {
                    i = 0;
                    while (i < newtDevices.size()) {
                        mon = (MonitorDevice)newtDevices.get(i);
                        mid = String.valueOf(mon.getId());
                        if (-1 < did.indexOf(mid)) {
                            monitor = mon;
                            break;
                        }
                        ++i;
                    }
                }
                if (monitor != null) {
                    this.monitors.add(monitor);
                }
                ++n3;
            }
        }
    }

    protected void initGL() {
        if (profile == null) {
            if (PJOGL.profile == 2) {
                try {
                    profile = GLProfile.getGL2ES2();
                }
                catch (GLException gLException) {
                    profile = GLProfile.getMaxProgrammable((boolean)true);
                }
            } else if (PJOGL.profile == 3) {
                try {
                    profile = GLProfile.getGL2GL3();
                }
                catch (GLException gLException) {
                    profile = GLProfile.getMaxProgrammable((boolean)true);
                }
                if (!profile.isGL3()) {
                    PGraphics.showWarning("Requested profile GL3 but is not available, got: " + profile);
                }
            } else if (PJOGL.profile == 4) {
                try {
                    profile = GLProfile.getGL4ES3();
                }
                catch (GLException gLException) {
                    profile = GLProfile.getMaxProgrammable((boolean)true);
                }
                if (!profile.isGL4()) {
                    PGraphics.showWarning("Requested profile GL4 but is not available, got: " + profile);
                }
            } else {
                throw new RuntimeException("Unsupported OpenGL profile.");
            }
        }
        GLCapabilities caps = new GLCapabilities(profile);
        caps.setAlphaBits(PGL.REQUESTED_ALPHA_BITS);
        caps.setDepthBits(PGL.REQUESTED_DEPTH_BITS);
        caps.setStencilBits(PGL.REQUESTED_STENCIL_BITS);
        this.pgl.reqNumSamples = PGL.smoothToSamples(this.graphics.smooth);
        caps.setSampleBuffers(true);
        caps.setNumSamples(this.pgl.reqNumSamples);
        caps.setBackgroundOpaque(true);
        caps.setOnscreen(true);
        this.pgl.capabilities = caps;
    }

    protected void initWindow() {
        int displayNum;
        this.window = GLWindow.create((Screen)this.screen, (GLCapabilitiesImmutable)this.pgl.capabilities);
        if (this.displayDevice == null) {
            this.displayDevice = this.window.getMainMonitor();
        }
        if ((displayNum = this.sketch.sketchDisplay()) > 0) {
            if (displayNum <= this.monitors.size()) {
                this.displayDevice = this.monitors.get(displayNum - 1);
            } else {
                System.err.format("Display %d does not exist, using the default display instead.%n", displayNum);
                int i = 0;
                while (i < this.monitors.size()) {
                    System.err.format("Display %d is %s%n", i + 1, this.monitors.get(i));
                    ++i;
                }
            }
        }
        boolean spanDisplays = this.sketch.sketchDisplay() == 0;
        this.screenRect = spanDisplays ? new Rectangle(0, 0, this.screen.getWidth(), this.screen.getHeight()) : new Rectangle(0, 0, this.displayDevice.getViewportInWindowUnits().getWidth(), this.displayDevice.getViewportInWindowUnits().getHeight());
        this.sketch.displayWidth = this.screenRect.width;
        this.sketch.displayHeight = this.screenRect.height;
        this.sketchWidth = this.sketch.sketchWidth();
        this.sketchHeight = this.sketch.sketchHeight();
        boolean fullScreen = this.sketch.sketchFullScreen();
        if (fullScreen || spanDisplays) {
            this.sketchWidth = this.screenRect.width;
            this.sketchHeight = this.screenRect.height;
        }
        float[] reqSurfacePixelScale = this.graphics.is2X() ? new float[]{0.0f, 0.0f} : new float[]{1.0f, 1.0f};
        this.window.setSurfaceScale(reqSurfacePixelScale);
        this.window.setSize(this.sketchWidth, this.sketchHeight);
        this.setSize(this.sketchWidth, this.sketchHeight);
        this.sketchX = this.displayDevice.getViewportInWindowUnits().getX();
        this.sketchY = this.displayDevice.getViewportInWindowUnits().getY();
        if (fullScreen) {
            PApplet.hideMenuBar();
            this.window.setTopLevelPosition(this.sketchX, this.sketchY);
            this.placedWindow = true;
            if (spanDisplays) {
                this.window.setFullscreen(this.monitors);
            } else {
                this.window.setFullscreen(true);
            }
        }
    }

    protected void initListeners() {
        NEWTMouseListener mouseListener = new NEWTMouseListener();
        this.window.addMouseListener((MouseListener)mouseListener);
        NEWTKeyListener keyListener = new NEWTKeyListener();
        this.window.addKeyListener((KeyListener)keyListener);
        NEWTWindowListener winListener = new NEWTWindowListener();
        this.window.addWindowListener((WindowListener)winListener);
        DrawListener drawlistener = new DrawListener();
        this.window.addGLEventListener((GLEventListener)drawlistener);
    }

    protected void initAnimator() {
        this.animator = new FPSAnimator((GLAutoDrawable)this.window, 60);
        this.drawException = null;
        this.animator.setUncaughtExceptionHandler(new GLAnimatorControl.UncaughtExceptionHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void uncaughtException(GLAnimatorControl animator, GLAutoDrawable drawable, Throwable cause) {
                Object object = PSurfaceJOGL.this.waitObject;
                synchronized (object) {
                    PSurfaceJOGL.this.drawException = cause;
                    PSurfaceJOGL.this.waitObject.notify();
                }
            }
        });
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = PSurfaceJOGL.this.waitObject;
                synchronized (object) {
                    Throwable cause;
                    try {
                        if (PSurfaceJOGL.this.drawException == null) {
                            PSurfaceJOGL.this.waitObject.wait();
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (PSurfaceJOGL.this.drawException != null && !((cause = PSurfaceJOGL.this.drawException.getCause()) instanceof ThreadDeath)) {
                        if (cause instanceof RuntimeException) {
                            throw (RuntimeException)cause;
                        }
                        throw new RuntimeException(cause);
                    }
                }
            }
        }).start();
    }

    @Override
    public void setTitle(String title) {
        this.window.setTitle(title);
    }

    @Override
    public void setVisible(boolean visible) {
        this.window.setVisible(visible);
    }

    @Override
    public void setResizable(boolean resizable) {
    }

    @Override
    public void setIcon(PImage icon) {
    }

    protected void initIcons() {
        int[] sizes = new int[]{16, 32, 48, 64, 128, 256, 512};
        String[] iconImages = new String[sizes.length];
        int i = 0;
        while (i < sizes.length) {
            iconImages[i] = "/icon/icon-" + sizes[i] + ".png";
            ++i;
        }
        NewtFactory.setWindowIcons((IOUtil.ClassResources)new IOUtil.ClassResources(PApplet.class, iconImages));
    }

    @Override
    public void placeWindow(int[] location, int[] editorLocation) {
        int x = this.window.getX() - this.window.getInsets().getLeftWidth();
        int y = this.window.getY() - this.window.getInsets().getTopHeight();
        int w = this.window.getWidth() + this.window.getInsets().getTotalWidth();
        int h = this.window.getHeight() + this.window.getInsets().getTotalHeight();
        if (location != null) {
            this.window.setTopLevelPosition(location[0], location[1]);
        } else if (editorLocation != null) {
            int locationX = editorLocation[0] - 20;
            int locationY = editorLocation[1];
            if (locationX - w > 10) {
                this.window.setTopLevelPosition(locationX - w, locationY);
            } else {
                locationX = editorLocation[0] + 66;
                locationY = editorLocation[1] + 66;
                if (locationX + w > this.sketch.displayWidth - 33 || locationY + h > this.sketch.displayHeight - 33) {
                    locationX = (this.sketch.displayWidth - w) / 2;
                    locationY = (this.sketch.displayHeight - h) / 2;
                }
                this.window.setTopLevelPosition(locationX, locationY);
            }
        } else {
            int sketchX = this.displayDevice.getViewportInWindowUnits().getX();
            int sketchY = this.displayDevice.getViewportInWindowUnits().getY();
            this.window.setTopLevelPosition(sketchX + this.screenRect.x + (this.screenRect.width - this.sketchWidth) / 2, sketchY + this.screenRect.y + (this.screenRect.height - this.sketchHeight) / 2);
        }
        Point frameLoc = new Point(x, y);
        if (frameLoc.y < 0) {
            this.window.setTopLevelPosition(frameLoc.x, 30);
        }
        this.placedWindow = true;
        if (this.requestedStart) {
            this.startThread();
        }
    }

    @Override
    public void placePresent(int stopColor) {
        this.pgl.presentMode = true;
        this.presentMode = true;
        this.offsetX = this.pgl.offsetX = 0.5f * (float)(this.screenRect.width - this.sketchWidth);
        this.offsetY = this.pgl.offsetY = 0.5f * (float)(this.screenRect.height - this.sketchHeight);
        this.pgl.requestFBOLayer();
        this.window.setSize(this.screenRect.width, this.screenRect.height);
        PApplet.hideMenuBar();
        this.window.setTopLevelPosition(this.sketchX + this.screenRect.x, this.sketchY + this.screenRect.y);
        this.window.setFullscreen(true);
        this.placedWindow = true;
        if (this.requestedStart) {
            this.startThread();
        }
    }

    @Override
    public void setupExternalMessages() {
    }

    @Override
    public void startThread() {
        if (this.animator != null) {
            if (this.placedWindow) {
                this.window.setVisible(true);
                this.animator.start();
                this.requestedStart = false;
            } else {
                this.requestedStart = true;
            }
        }
    }

    @Override
    public void pauseThread() {
        if (this.animator != null) {
            this.animator.pause();
        }
    }

    @Override
    public void resumeThread() {
        if (this.animator != null) {
            this.animator.resume();
        }
    }

    @Override
    public boolean stopThread() {
        if (this.animator != null) {
            return this.animator.stop();
        }
        return false;
    }

    @Override
    public boolean isStopped() {
        if (this.animator != null) {
            return !this.animator.isAnimating();
        }
        return true;
    }

    @Override
    public void setLocation(int x, int y) {
        if (this.window != null) {
            this.window.setTopLevelPosition(x, y);
        }
    }

    @Override
    public void setSize(int width, int height) {
        if (width == this.sketch.width && height == this.sketch.height) {
            return;
        }
        if (!this.presentMode) {
            this.sketch.setSize(width, height);
            this.sketchWidth = width;
            this.sketchHeight = height;
            this.graphics.setSize(width, height);
            this.window.setSize(width, height);
        }
    }

    public float getPixelScale() {
        if (this.graphics.is2X()) {
            this.window.getCurrentSurfaceScale(this.currentPixelScale);
            return this.currentPixelScale[0];
        }
        return 1.0f;
    }

    public Component getComponent() {
        return this.canvas;
    }

    public void setSmooth(int level) {
        this.pgl.reqNumSamples = level;
        GLCapabilities caps = new GLCapabilities(profile);
        caps.setAlphaBits(PGL.REQUESTED_ALPHA_BITS);
        caps.setDepthBits(PGL.REQUESTED_DEPTH_BITS);
        caps.setStencilBits(PGL.REQUESTED_STENCIL_BITS);
        caps.setSampleBuffers(true);
        caps.setNumSamples(this.pgl.reqNumSamples);
        caps.setBackgroundOpaque(true);
        caps.setOnscreen(true);
        NativeSurface target = this.window.getNativeSurface();
        MutableGraphicsConfiguration config = (MutableGraphicsConfiguration)target.getGraphicsConfiguration();
        config.setChosenCapabilities((CapabilitiesImmutable)caps);
    }

    @Override
    public void setFrameRate(float fps) {
        if (this.animator != null) {
            this.animator.stop();
            this.animator.setFPS((int)fps);
            this.pgl.setFps(fps);
            this.animator.start();
        }
    }

    public void requestFocus() {
        if (this.window != null) {
            this.window.requestFocus();
        }
    }

    protected void nativeMouseEvent(MouseEvent nativeEvent, int peAction) {
        int modifiers = nativeEvent.getModifiers();
        int peModifiers = modifiers & 0xF;
        int peButton = 0;
        if ((modifiers & 0x20) != 0) {
            peButton = 37;
        } else if ((modifiers & 0x40) != 0) {
            peButton = 3;
        } else if ((modifiers & 0x80) != 0) {
            peButton = 39;
        }
        if (PApplet.platform == 2 && (modifiers & 2) != 0) {
            peButton = 39;
        }
        int peCount = 0;
        peCount = peAction == 8 ? (nativeEvent.isShiftDown() ? (int)nativeEvent.getRotation()[0] : (int)nativeEvent.getRotation()[1]) : nativeEvent.getClickCount();
        this.window.getCurrentSurfaceScale(this.currentPixelScale);
        int sx = (int)((float)nativeEvent.getX() / this.currentPixelScale[0]);
        int sy = (int)((float)nativeEvent.getY() / this.currentPixelScale[1]);
        int mx = sx - (int)this.offsetX;
        int my = sy - (int)this.offsetY;
        if (this.presentMode) {
            if (peAction == 2 && 20 < sx && sx < 120 && this.screenRect.height - 70 < sy && sy < this.screenRect.height - 20) {
                this.sketch.exit();
            }
            if (mx < 0 || this.sketchWidth < mx || my < 0 || this.sketchHeight < my) {
                return;
            }
        }
        processing.event.MouseEvent me = new processing.event.MouseEvent(nativeEvent, nativeEvent.getWhen(), peAction, peModifiers, mx, my, peButton, peCount);
        this.sketch.postEvent(me);
    }

    protected void nativeKeyEvent(KeyEvent nativeEvent, int peAction) {
        char keyChar;
        int keyCode;
        int peModifiers = nativeEvent.getModifiers() & 0xF;
        short code = nativeEvent.getKeyCode();
        if (PSurfaceJOGL.isPCodedKey(code)) {
            keyCode = PSurfaceJOGL.mapToPConst(code);
            keyChar = '\uffff';
        } else if (PSurfaceJOGL.isHackyKey(code)) {
            keyCode = code;
            keyChar = PSurfaceJOGL.hackToChar(code, nativeEvent.getKeyChar());
        } else {
            keyCode = code;
            keyChar = nativeEvent.getKeyChar();
        }
        processing.event.KeyEvent ke = new processing.event.KeyEvent(nativeEvent, nativeEvent.getWhen(), peAction, peModifiers, keyChar, keyCode, nativeEvent.isAutoRepeat());
        this.sketch.postEvent(ke);
        if (!PSurfaceJOGL.isPCodedKey(code) && !PSurfaceJOGL.isHackyKey(code) && peAction == 1) {
            processing.event.KeyEvent tke = new processing.event.KeyEvent(nativeEvent, nativeEvent.getWhen(), 3, peModifiers, keyChar, 0, nativeEvent.isAutoRepeat());
            this.sketch.postEvent(tke);
        }
    }

    private static boolean isPCodedKey(short code) {
        return code == 150 || code == 152 || code == 149 || code == 151 || code == 18 || code == 17 || code == 15 || code == 154;
    }

    private static int mapToPConst(short code) {
        if (code == 150) {
            return 38;
        }
        if (code == 152) {
            return 40;
        }
        if (code == 149) {
            return 37;
        }
        if (code == 151) {
            return 39;
        }
        if (code == 18) {
            return 18;
        }
        if (code == 17) {
            return 17;
        }
        if (code == 15) {
            return 16;
        }
        if (code == 154) {
            return 157;
        }
        return code;
    }

    private static boolean isHackyKey(short code) {
        return code == 8 || code == 9;
    }

    private static char hackToChar(short code, char def) {
        if (code == 8) {
            return '\b';
        }
        if (code == 9) {
            return '\t';
        }
        return def;
    }

    @Override
    public void setCursor(int kind) {
        PGraphics.showWarning("Cursor types not yet supported in OpenGL, provide your cursor image");
    }

    @Override
    public void setCursor(PImage image, int hotspotX, int hotspotY) {
        Display disp = this.window.getScreen().getDisplay();
        disp.createNative();
    }

    @Override
    public void showCursor() {
        if (this.window != null) {
            this.window.setPointerVisible(true);
        }
    }

    @Override
    public void hideCursor() {
        if (this.window != null) {
            this.window.setPointerVisible(false);
        }
    }

    class DrawListener
    implements GLEventListener {
        DrawListener() {
        }

        public void display(GLAutoDrawable drawable) {
            PSurfaceJOGL.this.pgl.getGL(drawable);
            PSurfaceJOGL.this.sketch.handleDraw();
            if (PSurfaceJOGL.this.sketch.frameCount == 1) {
                PSurfaceJOGL.this.requestFocus();
            }
            if (PSurfaceJOGL.this.sketch.exitCalled()) {
                PSurfaceJOGL.this.animator.stop();
                PSurfaceJOGL.this.sketch.dispose();
                PSurfaceJOGL.this.sketch.exitActual();
            }
        }

        public void dispose(GLAutoDrawable drawable) {
            PSurfaceJOGL.this.sketch.dispose();
        }

        public void init(GLAutoDrawable drawable) {
            PSurfaceJOGL.this.pgl.getGL(drawable);
            PSurfaceJOGL.this.pgl.init(drawable);
            PSurfaceJOGL.this.sketch.start();
            int c = PSurfaceJOGL.this.graphics.backgroundColor;
            PSurfaceJOGL.this.pgl.clearColor((float)(c >> 16 & 0xFF) / 255.0f, (float)(c >> 8 & 0xFF) / 255.0f, (float)(c >> 0 & 0xFF) / 255.0f, (float)(c >> 24 & 0xFF) / 255.0f);
            PSurfaceJOGL.this.pgl.clear(PGL.COLOR_BUFFER_BIT);
        }

        public void reshape(GLAutoDrawable drawable, int x, int y, int w, int h) {
            PSurfaceJOGL.this.window.getCurrentSurfaceScale(PSurfaceJOGL.this.currentPixelScale);
            PSurfaceJOGL.this.pgl.getGL(drawable);
            PSurfaceJOGL.this.setSize((int)((float)w / PSurfaceJOGL.this.currentPixelScale[0]), (int)((float)h / PSurfaceJOGL.this.currentPixelScale[1]));
        }
    }

    protected class NEWTKeyListener
    extends KeyAdapter {
        public void keyPressed(KeyEvent e) {
            PSurfaceJOGL.this.nativeKeyEvent(e, 1);
        }

        public void keyReleased(KeyEvent e) {
            PSurfaceJOGL.this.nativeKeyEvent(e, 2);
        }

        public void keyTyped(KeyEvent e) {
            PSurfaceJOGL.this.nativeKeyEvent(e, 3);
        }
    }

    protected class NEWTMouseListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            PSurfaceJOGL.this.nativeMouseEvent(e, 1);
        }

        public void mouseReleased(MouseEvent e) {
            PSurfaceJOGL.this.nativeMouseEvent(e, 2);
        }

        public void mouseClicked(MouseEvent e) {
            PSurfaceJOGL.this.nativeMouseEvent(e, 3);
        }

        public void mouseDragged(MouseEvent e) {
            PSurfaceJOGL.this.nativeMouseEvent(e, 4);
        }

        public void mouseMoved(MouseEvent e) {
            PSurfaceJOGL.this.nativeMouseEvent(e, 5);
        }

        public void mouseWheelMoved(MouseEvent e) {
            PSurfaceJOGL.this.nativeMouseEvent(e, 8);
        }

        public void mouseEntered(MouseEvent e) {
            PSurfaceJOGL.this.nativeMouseEvent(e, 6);
        }

        public void mouseExited(MouseEvent e) {
            PSurfaceJOGL.this.nativeMouseEvent(e, 7);
        }
    }

    protected class NEWTWindowListener
    implements WindowListener {
        public void windowGainedFocus(WindowEvent arg0) {
            PSurfaceJOGL.this.sketch.focused = true;
            PSurfaceJOGL.this.sketch.focusGained();
        }

        public void windowLostFocus(WindowEvent arg0) {
            PSurfaceJOGL.this.sketch.focused = false;
            PSurfaceJOGL.this.sketch.focusLost();
        }

        public void windowDestroyNotify(WindowEvent arg0) {
            PSurfaceJOGL.this.sketch.dispose();
            PSurfaceJOGL.this.sketch.exitActual();
        }

        public void windowDestroyed(WindowEvent arg0) {
        }

        public void windowMoved(WindowEvent arg0) {
        }

        public void windowRepaint(WindowUpdateEvent arg0) {
        }

        public void windowResized(WindowEvent arg0) {
        }
    }
}

