/*
public class ColorPicker 
{
  int x, y, w, h, c;
  int pickX = 0, pickY = 0;
  PImage cpImage;

  public ColorPicker ( int x, int y, int w, int h, int c )
  {
    this.x = x;
    this.y = y;
    this.w = w;
    this.h = h;
    this.c = c;

    cpImage = new PImage( w, h );

    init();
  }

  private void init ()
  {
    // draw color.
    int cw = w - 35;
    for ( int i=0; i<cw; ++i ) 
    {
      float nColorPercent = i / (float)cw;
      float rad = (-360 * nColorPercent) * (PI / 180);
      int nR = (int)(cos(rad) * 127 + 128) << 16;
      int nG = (int)(cos(rad + 2 * PI / 3) * 127 + 128) << 8;
      int nB = (int)(Math.cos(rad + 4 * PI / 3) * 127 + 128);
      int nColor = nR | nG | nB;

      setGradient( i, 0, 1, h/2, 0xFFFFFF, nColor );
      setGradient( i, (h/2), 1, h/2, nColor, 0x000000 );
    }

    // draw black/white.
    drawRect( cw, 0, 30, h/2, 0xFFFFFF );
    drawRect( cw, h/2, 30, h/2, 0 );

    // draw grey scale.
    for ( int j=0; j<h; ++j )
    {
      int g = 255 - (int)(j/(float)(h-1) * 255 );
      drawRect( w-20, j, 20, 1, color( g, g, g ) );
    }
  }

  private void setGradient(int x, int y, float w, float h, int c1, int c2 )
  {
    float deltaR = red(c2) - red(c1);
    float deltaG = green(c2) - green(c1);
    float deltaB = blue(c2) - blue(c1);

    for (int j=y; j<(y+h); ++j)
    {
      int c = color( red(c1)+(j-y)*(deltaR/h), green(c1)+(j-y)*(deltaG/h), blue(c1)+(j-y)*(deltaB/h) );
      cpImage.set( x, j, c );
    }
  }

  private void drawRect( int rx, int ry, int rw, int rh, int rc )
  {
    for (int i=rx; i<rx+rw; ++i) 
    {
      for (int j=ry; j<ry+rh; ++j) 
      {
        cpImage.set( i, j, rc );
      }
    }
  }

  public void render ()
  {
    image( cpImage, x, y );
    if ( mousePressed && mouseX >= x && mouseX < x + w && !(mouseX > w+x-35 && mouseX < w+x-20) && mouseY >= y && mouseY < y + h )
    {
      c = get( mouseX, mouseY );
      pickX = mouseX;
      pickY = mouseY;
    }
    fill( c );
    strokeWeight(1);
    rect( x, y+h+10, 20, 20 );

    // Draw current color selected circle
    if (pickX != 0 && pickY != 0) {
      noFill();
      stroke(#000000);
      strokeWeight(1);
      ellipse(pickX, pickY, 10, 10);
    }

    // Draw borders
    noFill();
    stroke(#000000);
    strokeWeight(1.5);
    rect(x, y, w-35, h);
    rect(x+w-20, y, 20, h);
  }
}
*/